/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.Color;
import com.arcway.planagent.planeditor.Messages;
import java.util.HashMap;
import java.util.Map;

public class NamedColor {
    public static final Color[] DEFAULT_PALETTE = new Color[]{new Color(255, 255, 255), new Color(191, 191, 191), new Color(127, 127, 127), new Color(63, 63, 63), new Color(0, 0, 0), new Color(255, 255, 78), new Color(206, 103, 0), new Color(121, 0, 0), new Color(0, 0, 128), new Color(18, 119, 0), new Color(137, 117, 37)};
    protected static final Color[] DEFAULT_FILL_PALETTE = new Color[]{new Color(255, 255, 255), new Color(191, 191, 191), new Color(127, 127, 127), new Color(63, 63, 63), new Color(0, 0, 0), new Color(255, 255, 204), new Color(255, 255, 77), new Color(248, 228, 195), new Color(249, 211, 104), new Color(249, 140, 9), new Color(255, 232, 232), new Color(255, 147, 147), new Color(202, 40, 40), new Color(203, 227, 244), new Color(160, 196, 247), new Color(123, 173, 193), new Color(165, 116, 255), new Color(202, 252, 83), new Color(224, 251, 193), new Color(150, 231, 55), new Color(120, 183, 47)};
    private static final Map<Color, String> COLOR_TO_NAME = new HashMap<Color, String>(50);
    private static final Map<String, Color> NAME_TO_COLOR;
    private final Color color;
    private final String name;

    static {
        COLOR_TO_NAME.put(new Color(255, 255, 255), Messages.getString("NamedColor.White"));
        COLOR_TO_NAME.put(new Color(191, 191, 191), Messages.getString("NamedColor.Gray_25"));
        COLOR_TO_NAME.put(new Color(127, 127, 127), Messages.getString("NamedColor.Gray_50"));
        COLOR_TO_NAME.put(new Color(63, 63, 63), Messages.getString("NamedColor.Gray_75"));
        COLOR_TO_NAME.put(new Color(0, 0, 0), Messages.getString("NamedColor.Black"));
        COLOR_TO_NAME.put(new Color(203, 227, 244), Messages.getString("NamedColor.Blue_1"));
        COLOR_TO_NAME.put(new Color(160, 196, 247), Messages.getString("NamedColor.Blue_2"));
        COLOR_TO_NAME.put(new Color(123, 173, 193), Messages.getString("NamedColor.Blue_3"));
        COLOR_TO_NAME.put(new Color(0, 0, 128), Messages.getString("NamedColor.Blue_4"));
        COLOR_TO_NAME.put(new Color(248, 228, 195), Messages.getString("NamedColor.Orange_1"));
        COLOR_TO_NAME.put(new Color(249, 211, 104), Messages.getString("NamedColor.Orange_2"));
        COLOR_TO_NAME.put(new Color(249, 140, 9), Messages.getString("NamedColor.Orange_3"));
        COLOR_TO_NAME.put(new Color(137, 117, 37), Messages.getString("NamedColor.Brown"));
        COLOR_TO_NAME.put(new Color(255, 255, 204), Messages.getString("NamedColor.Yellow1"));
        COLOR_TO_NAME.put(new Color(255, 255, 77), Messages.getString("NamedColor.Yellow2"));
        COLOR_TO_NAME.put(new Color(255, 255, 78), Messages.getString("NamedColor.Yellow"));
        COLOR_TO_NAME.put(new Color(206, 103, 0), Messages.getString("NamedColor.Orange_4"));
        COLOR_TO_NAME.put(new Color(255, 232, 232), Messages.getString("NamedColor.Red_1"));
        COLOR_TO_NAME.put(new Color(255, 147, 147), Messages.getString("NamedColor.Red_2"));
        COLOR_TO_NAME.put(new Color(202, 40, 40), Messages.getString("NamedColor.Red_3"));
        COLOR_TO_NAME.put(new Color(121, 0, 0), Messages.getString("NamedColor.Red_4"));
        COLOR_TO_NAME.put(new Color(202, 252, 83), Messages.getString("NamedColor.Green_Lime"));
        COLOR_TO_NAME.put(new Color(224, 251, 193), Messages.getString("NamedColor.Green_1"));
        COLOR_TO_NAME.put(new Color(150, 231, 55), Messages.getString("NamedColor.Green_2"));
        COLOR_TO_NAME.put(new Color(120, 183, 47), Messages.getString("NamedColor.Green_3"));
        COLOR_TO_NAME.put(new Color(18, 119, 0), Messages.getString("NamedColor.Green_4"));
        COLOR_TO_NAME.put(new Color(165, 116, 255), Messages.getString("NamedColor.Purple"));
        NAME_TO_COLOR = new HashMap<String, Color>(50);
        NAME_TO_COLOR.put(Messages.getString("NamedColor.White"), new Color(255, 255, 255));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Gray_25"), new Color(191, 191, 191));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Gray_50"), new Color(127, 127, 127));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Gray_75"), new Color(63, 63, 63));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Black"), new Color(0, 0, 0));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Blue_1"), new Color(203, 227, 244));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Blue_2"), new Color(160, 196, 247));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Blue_3"), new Color(123, 173, 193));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Blue_4"), new Color(0, 0, 128));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Orange_1"), new Color(248, 228, 195));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Orange_2"), new Color(249, 211, 104));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Orange_3"), new Color(249, 140, 9));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Brown"), new Color(137, 117, 37));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Yellow1"), new Color(255, 255, 204));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Yellow2"), new Color(255, 255, 77));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Yellow"), new Color(255, 255, 78));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Orange_4"), new Color(206, 103, 0));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Red_1"), new Color(255, 232, 232));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Red_2"), new Color(255, 147, 147));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Red_3"), new Color(202, 40, 40));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Red_4"), new Color(121, 0, 0));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Green_Lime"), new Color(202, 252, 83));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Green_1"), new Color(224, 251, 193));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Green_2"), new Color(150, 231, 55));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Green_3"), new Color(120, 183, 47));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Green_4"), new Color(18, 119, 0));
        NAME_TO_COLOR.put(Messages.getString("NamedColor.Purple"), new Color(165, 116, 255));
    }

    public static String getNameForColor(Color color) {
        String name = COLOR_TO_NAME.get(color);
        if (name == null) {
            name = String.valueOf(Messages.getString("NamedColor.RGB")) + " " + color.r + ", " + color.g + ", " + color.b;
        }
        return name;
    }

    public static Color getColorForName(String name) {
        Color color = NAME_TO_COLOR.get(name);
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public NamedColor(Color color, String name) {
        this.color = new Color(color);
        this.name = name;
    }

    public Color getColor() {
        return new Color(this.color);
    }

    public String getName() {
        return this.name;
    }
}

