/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.Color;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.AbstractColorDecoration;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class LineColorDecoration
extends AbstractColorDecoration {
    private static LineColorDecoration instance = new LineColorDecoration();

    public static LineColorDecoration getInstance() {
        return instance;
    }

    private LineColorDecoration() {
    }

    @Override
    public Class[] getAppearanceClasses() {
        return new Class[]{ILineAppearanceRO.class, ILineMarkerAppearanceRO.class};
    }

    @Override
    public Object getStateOfAppearance(IAppearanceRO appearance) {
        Color color = null;
        if (appearance instanceof ILineAppearanceRO) {
            ILineAppearanceRO lineAppearance = (ILineAppearanceRO)appearance;
            color = lineAppearance.getLineColor();
        } else if (appearance instanceof ILineMarkerAppearanceRO) {
            ILineMarkerAppearanceRO markerAppearance = (ILineMarkerAppearanceRO)appearance;
            color = markerAppearance.getLineMarkerColor();
        }
        return color;
    }

    @Override
    public String getToolTipText(Object state) {
        return String.valueOf(Messages.getString("LineColorDecoration.Line_Color")) + this.getMenuEntryText(state);
    }

    @Override
    public ImageDescriptor getButtonImageDescriptor(Object state) {
        ImageDescriptor subImage = ResourceLoader.getImageDescriptor((String)"line.png", (Plugin)FMCAPlanEditorPlugin.getDefault());
        return this.getCombiImage((Color)state, subImage);
    }

    @Override
    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        LineAppearanceTpl lineTpl = new LineAppearanceTpl();
        if (state == null) {
            lineTpl.setLineColor(Color.TRANSPARENT);
        } else {
            lineTpl.setLineColor((Color)state);
        }
        LineMarkerAppearanceTpl markerTpl = new LineMarkerAppearanceTpl();
        if (state == null) {
            markerTpl.setLineMarkerColor(Color.TRANSPARENT);
        } else {
            markerTpl.setLineMarkerColor((Color)state);
        }
        return new IAppearanceTpl[]{lineTpl, markerTpl};
    }

    @Override
    protected String getUnfilledName() {
        return Messages.getString("LineColorDecoration.NoLine");
    }
}

