/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.AbstractColorDecoration;
import com.arcway.planagent.planmodel.appearance.FillAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class FillColorDecoration
extends AbstractColorDecoration {
    private static FillColorDecoration instance = new FillColorDecoration();

    public static FillColorDecoration getInstance() {
        return instance;
    }

    private FillColorDecoration() {
    }

    @Override
    public Class[] getAppearanceClasses() {
        return new Class[]{IFillAppearanceRO.class, ILineMarkerAppearanceRO.class};
    }

    @Override
    public Object getStateOfAppearance(IAppearanceRO appearance) {
        ILineMarkerAppearanceRO lineMarkerAppearance;
        FillColor state = null;
        if (appearance instanceof IFillAppearanceRO) {
            state = ((IFillAppearanceRO)appearance).getFillColor();
        } else if (appearance instanceof ILineMarkerAppearanceRO && (lineMarkerAppearance = (ILineMarkerAppearanceRO)appearance).getLineMarkerStyle().usesFillColor()) {
            state = lineMarkerAppearance.getLineMarkerFillColor();
        }
        return state;
    }

    @Override
    public String getToolTipText(Object state) {
        return String.valueOf(Messages.getString("FillColorDecoration.Fill_Color")) + this.getMenuEntryText(state);
    }

    @Override
    public ImageDescriptor getMenuEntryImage(Object state) {
        FillColor fillColor = (FillColor)state;
        return super.getMenuEntryImage(this.fillColorToColor(fillColor), fillColor == null ? 255 : fillColor.foregroundAlpha);
    }

    @Override
    public String getMenuEntryText(Object state) {
        FillColor fillColor = (FillColor)state;
        String colorText = super.getMenuEntryText(this.fillColorToColor(fillColor));
        int alpha = fillColor.foregroundAlpha;
        String alphaText = alpha == 255 ? "" : " (" + Math.round(100.0f * (float)alpha / 255.0f) + "%)";
        return String.valueOf(colorText) + alphaText;
    }

    @Override
    public ImageDescriptor getButtonImageDescriptor(Object state) {
        ImageDescriptor subImage = ResourceLoader.getImageDescriptor((String)"fill.png", (Plugin)FMCAPlanEditorPlugin.getDefault());
        FillColor fillColor = (FillColor)state;
        return this.getCombiImage(this.fillColorToColor(fillColor), subImage, fillColor == null ? 255 : fillColor.foregroundAlpha);
    }

    @Override
    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        FillAppearanceTpl fillTpl = new FillAppearanceTpl();
        LineMarkerAppearanceTpl markerTpl = new LineMarkerAppearanceTpl();
        if (state != null) {
            fillTpl.setFillColor((FillColor)state);
            markerTpl.setLineMarkerFillColor((FillColor)state);
        } else {
            fillTpl.setFillColor(FillColor.TRANSPARENT);
            markerTpl.setLineMarkerFillColor(FillColor.TRANSPARENT);
        }
        return new IAppearanceTpl[]{fillTpl, markerTpl};
    }

    private Color fillColorToColor(FillColor fillColor) {
        Color color;
        if (fillColor == null) {
            color = null;
        } else {
            color = fillColor.foregroundColor;
            color.transparent = fillColor.foregroundAlpha == 0;
        }
        return color;
    }

    @Override
    protected String getUnfilledName() {
        return Messages.getString("FillColorDecoration.NoFill");
    }
}

