/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.ExecutableCommand;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class EditorActionProvider {
    private final IWorkbenchWindow workbenchWindow;
    private final IAppearanceButtonDecoration buttonType;

    public EditorActionProvider(IWorkbenchWindow window, IAppearanceButtonDecoration buttonType) {
        assert (window != null) : "WorkbenchWindow is null";
        assert (buttonType != null) : "buttonType is null";
        this.workbenchWindow = window;
        this.buttonType = buttonType;
    }

    public boolean testEnabled(AppearanceUtil.SelectionInfoProvider selectionInfo, Object state) {
        ExecutableCommand command = AppearanceUtil.getCommand(selectionInfo, this.buttonType, state);
        boolean enabled = command != null;
        return enabled;
    }

    public AppearanceUtil.SelectionInfoProvider getCurrentSelectionInfo() {
        return EditorActionProvider.getCurrentSelectionInfo(this.workbenchWindow, this.buttonType);
    }

    public static AppearanceUtil.SelectionInfoProvider getCurrentSelectionInfo(IWorkbenchWindow workbenchWindow, IAppearanceButtonDecoration buttonType) {
        ISelection currentSelection = null;
        ISelectionProvider selectionProvider = EditorActionProvider.getCurrentSelectionProvider(workbenchWindow);
        if (selectionProvider != null) {
            currentSelection = selectionProvider.getSelection();
        }
        return new AppearanceUtil.SelectionInfoProvider(buttonType, currentSelection);
    }

    private static ISelectionProvider getCurrentSelectionProvider(IWorkbenchWindow workbenchWindow) {
        ISelectionProvider currentSelectionProvider = null;
        IEditorPart activeEditor = EditorActionProvider.getActiveEditor(workbenchWindow);
        if (activeEditor != null) {
            currentSelectionProvider = activeEditor.getEditorSite().getSelectionProvider();
        }
        return currentSelectionProvider;
    }

    private static IEditorPart getActiveEditor(IWorkbenchWindow workbenchWindow) {
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }
}

