/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.CILineWidthConstantsAndMaps;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchPage;

public class CILineWidth
extends MenuContributionItem {
    private Map<String, Double> extraWidthMaps;

    public CILineWidth() {
    }

    public CILineWidth(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    @Override
    protected IAppearanceButtonDecoration getButtonType() {
        return CILineWidthConstantsAndMaps.APPEARANCE_DECORATION;
    }

    private List<IContributionItem> constructContributionItem() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, CILineWidthConstantsAndMaps.INIT_WIDTH);
        ArrayList<Object> selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (String actionID : CILineWidthConstantsAndMaps.sortedLineWidthIDList) {
            Double width = CILineWidthConstantsAndMaps.widthMaps.get(actionID);
            String widthName = ((IAppearanceButtonDecorationWithMenu)CILineWidthConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText(width);
            UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, actionID, widthName, width, CILineWidthConstantsAndMaps.APPEARANCE_DECORATION);
            action.setEnabled(enabled);
            boolean checked = false;
            if (enabled) {
                checked = this.isActionChecked(width, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        this.checkForNewLineWidth(selectedStates);
        Set<String> extraWidths = this.extraWidthMaps.keySet();
        if (!extraWidths.isEmpty()) {
            items.add((IContributionItem)new Separator());
        }
        for (String actionID : extraWidths) {
            Double width = this.extraWidthMaps.get(actionID);
            String widthName = ((IAppearanceButtonDecorationWithMenu)CILineWidthConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText(width);
            UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, actionID, widthName, width, CILineWidthConstantsAndMaps.APPEARANCE_DECORATION);
            action.setEnabled(enabled);
            boolean checked = false;
            if (enabled) {
                checked = this.isActionChecked(width, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        return items;
    }

    private void checkForNewLineWidth(ArrayList<Object> selectedStates) {
        this.extraWidthMaps = new HashMap<String, Double>();
        for (Object state : selectedStates) {
            Double width;
            if (!(state instanceof Double) || !this.isNewLineWidth(width = (Double)state)) continue;
            String actionID = "com.arcway.cockpitplanahent.editor.actions.linewidth." + width.toString();
            this.extraWidthMaps.put(actionID, width);
        }
    }

    private boolean isNewLineWidth(Double state) {
        boolean newState = true;
        if (CILineWidthConstantsAndMaps.widthMaps.containsValue(state)) {
            newState = false;
        }
        return newState;
    }

    private boolean isActionChecked(Double width, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            Double selectedWidth;
            if (state instanceof Double && (checked = width.equals(selectedWidth = (Double)state))) break;
        }
        return checked;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] lineWidthItems = items.toArray(new IContributionItem[items.size()]);
        return lineWidthItems;
    }
}

