/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.LineStartMarkerDecoration;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class CILineStartMarker
extends MenuContributionItem {
    private static final String action_id_startarrow_none = "com.arcway.cockpitplanagent.editor.actions.startarrow.01.none";
    private static final String action_id_startarrow_dot = "com.arcway.cockpitplanagent.editor.actions.startarrow.02.dot";
    private static final String action_id_startarrow_bobble = "com.arcway.cockpitplanagent.editor.actions.startarrow.03.bobble";
    private static final String action_id_startarrow_dash = "com.arcway.cockpitplanagent.editor.actions.startarrow.04.dash";
    private static final String action_id_startarrow_cross = "com.arcway.cockpitplanagent.editor.actions.startarrow.05.cross";
    private static final String action_id_startarrow_diamond = "com.arcway.cockpitplanagent.editor.actions.startarrow.06.diamond";
    private static final String action_id_startarrow_circle = "com.arcway.cockpitplanagent.editor.actions.startarrow.07.circle";
    private static final String action_id_startarrow_rhombus = "com.arcway.cockpitplanagent.editor.actions.startarrow.08.rhombus";
    private static final String action_id_startarrow_triangle = "com.arcway.cockpitplanagent.editor.actions.startarrow.09.triangle";
    private static final String action_id_startarrow_roundedarc = "com.arcway.cockpitplanagent.editor.actions.startarrow.10.roundedarc";
    private static final String action_id_startarrow_roundedarc_filled = "com.arcway.cockpitplanagent.editor.actions.endarrow.11.roundedarcfilled";
    private static final String action_id_startarrow_peakedarc = "com.arcway.cockpitplanagent.editor.actions.startarrow.12.peakedarc";
    private static final String action_id_startarrow_peakedarcfilled = "com.arcway.cockpitplanagent.editor.actions.endarrow.13.peakedarcfilled";
    private static final String action_id_startarrow_arrow = "com.arcway.cockpitplanagent.editor.actions.startarrow.14.arrow";
    private static final Map<String, LineMarker> markerMaps = new HashMap<String, LineMarker>();
    private static ArrayList<String> sortedMarkerIDList;
    private static final IAppearanceButtonDecoration buttonType;
    private static final LineMarker initMarker;

    static {
        markerMaps.put(action_id_startarrow_none, LineMarker.NONE);
        markerMaps.put(action_id_startarrow_dot, LineMarker.DOT);
        markerMaps.put(action_id_startarrow_bobble, LineMarker.BOBBLE);
        markerMaps.put(action_id_startarrow_dash, LineMarker.DASH);
        markerMaps.put(action_id_startarrow_cross, LineMarker.CROSS);
        markerMaps.put(action_id_startarrow_diamond, LineMarker.DIAMOND);
        markerMaps.put(action_id_startarrow_circle, LineMarker.CIRCLE);
        markerMaps.put(action_id_startarrow_rhombus, LineMarker.RHOMBUS);
        markerMaps.put(action_id_startarrow_triangle, LineMarker.TRIANGLE);
        markerMaps.put(action_id_startarrow_roundedarc, LineMarker.ROUNDED_ARC);
        markerMaps.put(action_id_startarrow_roundedarc_filled, LineMarker.ROUNDED_ARC_FILLED);
        markerMaps.put(action_id_startarrow_peakedarc, LineMarker.PEAKED_ARC);
        markerMaps.put(action_id_startarrow_peakedarcfilled, LineMarker.PEAKED_ARC_FILLED);
        markerMaps.put(action_id_startarrow_arrow, LineMarker.ARROW);
        sortedMarkerIDList = new ArrayList();
        Set<String> markerIDList = markerMaps.keySet();
        ArrayList<String> idList = new ArrayList<String>(markerIDList);
        Collections.sort(idList);
        sortedMarkerIDList = idList;
        buttonType = LineStartMarkerDecoration.getInstance();
        initMarker = LineMarker.NONE;
    }

    public CILineStartMarker() {
    }

    public CILineStartMarker(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    @Override
    protected IAppearanceButtonDecoration getButtonType() {
        return buttonType;
    }

    private List<IContributionItem> constructContributionItem() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, initMarker);
        ArrayList<Object> selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (String actionID : sortedMarkerIDList) {
            LineMarker marker = markerMaps.get(actionID);
            String markerName = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryText(marker);
            UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, actionID, markerName, marker, buttonType);
            ImageDescriptor imageDescriptor = buttonType.getButtonImageDescriptor(marker);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            boolean checked = false;
            if (enabled) {
                checked = this.isActionChecked(marker, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        return items;
    }

    private boolean isActionChecked(LineMarker marker, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            if (!(state instanceof LineMarker)) continue;
            LineMarker selectedMarker = (LineMarker)state;
            checked = marker.getClass().equals(selectedMarker.getClass());
            if (checked) break;
        }
        return checked;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] colorItems = items.toArray(new IContributionItem[items.size()]);
        return colorItems;
    }
}

