/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.Color;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.CILineColorConstantsAndMaps;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class CILineColor
extends MenuContributionItem {
    private Map<String, Color> extraColorMaps;

    public CILineColor() {
    }

    public CILineColor(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    @Override
    protected IAppearanceButtonDecoration getButtonType() {
        return CILineColorConstantsAndMaps.APPEARANCE_DECORATION;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] colorItems = items.toArray(new IContributionItem[items.size()]);
        return colorItems;
    }

    private List<IContributionItem> constructContributionItem() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        CILineColorConstantsAndMaps.changeColorAction.init(workbenchPage);
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, CILineColorConstantsAndMaps.INIT_COLOR);
        ArrayList<Object> selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        Color lineColor = Color.TRANSPARENT;
        String colorName = Messages.getString("LineColorDecoration.NoLine");
        UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, "com.arcway.cockpitplanagent.editor.actions.linecolor..none", colorName, lineColor, CILineColorConstantsAndMaps.APPEARANCE_DECORATION);
        action.setEnabled(enabled);
        boolean checked = false;
        if (enabled) {
            checked = this.isActionChecked(lineColor, selectedStates);
        }
        action.setChecked(checked);
        action.setImageDescriptor(((IAppearanceButtonDecorationWithMenu)CILineColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage(null));
        items.add((IContributionItem)new ActionContributionItem((IAction)action));
        items.add((IContributionItem)new Separator());
        for (String actionID : CILineColorConstantsAndMaps.sortedColorIDList) {
            Color color = CILineColorConstantsAndMaps.colorMaps.get(actionID);
            colorName = ((IAppearanceButtonDecorationWithMenu)CILineColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText(color);
            action = new UIChangeAppearanceAction(workbenchPage, actionID, colorName, color, CILineColorConstantsAndMaps.APPEARANCE_DECORATION);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CILineColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage(color);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            checked = false;
            if (enabled) {
                checked = this.isActionChecked(color, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        this.checkForNewColor(selectedStates);
        Set<String> extraColors = this.extraColorMaps.keySet();
        if (!extraColors.isEmpty()) {
            items.add((IContributionItem)new Separator());
        }
        for (String actionID : extraColors) {
            Color color = this.extraColorMaps.get(actionID);
            colorName = ((IAppearanceButtonDecorationWithMenu)CILineColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText(color);
            action = new UIChangeAppearanceAction(workbenchPage, actionID, colorName, color, CILineColorConstantsAndMaps.APPEARANCE_DECORATION);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CILineColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage(color);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            checked = false;
            if (enabled) {
                checked = this.isActionChecked(color, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        items.add((IContributionItem)new Separator());
        Color dialogColor = CILineColorConstantsAndMaps.changeColorAction.getColor();
        if (!dialogColor.equalsColor(CILineColorConstantsAndMaps.INIT_COLOR)) {
            colorName = ((IAppearanceButtonDecorationWithMenu)CILineColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText(dialogColor);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CILineColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage(dialogColor);
            action = new UIChangeAppearanceAction(workbenchPage, "com.arcway.cockpitplanagent.editor.actions.linecolor..custom", colorName, dialogColor, CILineColorConstantsAndMaps.APPEARANCE_DECORATION);
            action.setImageDescriptor(imageDescriptor);
            if (enabled) {
                checked = this.isActionChecked(dialogColor, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        CILineColorConstantsAndMaps.changeColorAction.setEnabled(enabled);
        CILineColorConstantsAndMaps.changeColorAction.setChecked(false);
        items.add((IContributionItem)new ActionContributionItem((IAction)CILineColorConstantsAndMaps.changeColorAction));
        return items;
    }

    private void checkForNewColor(ArrayList<Object> selectedStates) {
        this.extraColorMaps = new HashMap<String, Color>();
        for (Object state : selectedStates) {
            Color color;
            if (!(state instanceof Color) || !this.isNewColor(color = (Color)state)) continue;
            String actionID = "com.arcway.cockpitplanagent.editor.actions.linecolor." + color.toString();
            this.extraColorMaps.put(actionID, color);
        }
    }

    private boolean isActionChecked(Color color, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            Color selectedColor;
            if (state instanceof Color && (checked = color.equalsColor(selectedColor = (Color)state))) break;
        }
        return checked;
    }

    private boolean isNewColor(Color state) {
        boolean newState = true;
        Color dialogColor = CILineColorConstantsAndMaps.changeColorAction.getColor();
        if (dialogColor.equalsColor(state)) {
            return false;
        }
        for (Color color : CILineColorConstantsAndMaps.colorMaps.values()) {
            if (!color.equalsColor(state)) continue;
            newState = false;
            break;
        }
        return newState;
    }
}

