/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.graphics.FillColor;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.CIFillColorConstantsAndMaps;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class CIFillColor
extends MenuContributionItem {
    public CIFillColor() {
    }

    public CIFillColor(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    @Override
    protected IAppearanceButtonDecoration getButtonType() {
        return CIFillColorConstantsAndMaps.APPEARANCE_DECORATION;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] colorItems = items.toArray(new IContributionItem[items.size()]);
        return colorItems;
    }

    private List<IContributionItem> constructContributionItem() {
        SortedMap<String, FillColor> extraColorMaps;
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        CIFillColorConstantsAndMaps.changeFillColorAction.init(workbenchPage);
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, CIFillColorConstantsAndMaps.INIT_COLOR);
        ArrayList<Object> selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        FillColor fillColor = FillColor.TRANSPARENT;
        String colorName = Messages.getString("FillColorDecoration.NoFill");
        UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, "com.arcway.cockpitplanagent.editor.actions.fillcolor.none", colorName, fillColor, CIFillColorConstantsAndMaps.APPEARANCE_DECORATION);
        action.setEnabled(enabled);
        boolean checked = false;
        if (enabled) {
            checked = CIFillColor.isActionChecked(fillColor, selectedStates);
        }
        action.setChecked(checked);
        action.setImageDescriptor(((IAppearanceButtonDecorationWithMenu)CIFillColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage(null));
        items.add((IContributionItem)new ActionContributionItem((IAction)action));
        items.add((IContributionItem)new Separator());
        SortedMap<String, FillColor> uniqueSelectedColor = CIFillColor.getUniqueSelectedColor(selectedStates);
        Integer uniqueAlpha = uniqueSelectedColor.isEmpty() ? null : Integer.valueOf(uniqueSelectedColor.values().iterator().next().foregroundAlpha);
        for (String actionID : CIFillColorConstantsAndMaps.sortedColorIDList) {
            fillColor = CIFillColorConstantsAndMaps.colorMaps.get(actionID);
            if (uniqueAlpha != null) {
                fillColor = fillColor.replaceForegroundOpacity(uniqueAlpha.intValue());
            }
            colorName = ((IAppearanceButtonDecorationWithMenu)CIFillColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText(fillColor);
            action = new UIChangeAppearanceAction(workbenchPage, actionID, colorName, fillColor, CIFillColorConstantsAndMaps.APPEARANCE_DECORATION);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CIFillColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage(fillColor);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            checked = false;
            if (enabled) {
                checked = CIFillColor.isActionChecked(fillColor, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        if (uniqueSelectedColor.isEmpty()) {
            extraColorMaps = CIFillColor.checkForNewColor(selectedStates);
        } else {
            extraColorMaps = new TreeMap<String, FillColor>();
            Map.Entry<String, FillColor> entry = uniqueSelectedColor.entrySet().iterator().next();
            String uniqueColorActionID = entry.getKey();
            FillColor uniqueColor = entry.getValue();
            TreeSet<Integer> alphas = new TreeSet<Integer>(CIFillColorConstantsAndMaps.alphas);
            alphas.add(uniqueColor.foregroundAlpha);
            for (Integer alpha : alphas) {
                String currentActionID;
                FillColor currentFillColor;
                int alphaInt = alpha;
                if (alphaInt == uniqueColor.foregroundAlpha) {
                    currentFillColor = uniqueColor;
                    currentActionID = uniqueColorActionID;
                } else {
                    currentFillColor = uniqueColor.replaceForegroundOpacity(alphaInt);
                    currentActionID = "com.arcway.cockpitplanagent.editor.actions.fillcolor" + currentFillColor.toString();
                }
                extraColorMaps.put(currentActionID, currentFillColor);
            }
        }
        Set<String> extraColors = extraColorMaps.keySet();
        if (!extraColors.isEmpty()) {
            items.add((IContributionItem)new Separator());
        }
        for (String actionID : extraColors) {
            FillColor color = (FillColor)extraColorMaps.get(actionID);
            colorName = ((IAppearanceButtonDecorationWithMenu)CIFillColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText(color);
            action = new UIChangeAppearanceAction(workbenchPage, actionID, colorName, color, CIFillColorConstantsAndMaps.APPEARANCE_DECORATION);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CIFillColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage(color);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            checked = false;
            if (enabled) {
                checked = CIFillColor.isActionChecked(color, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        items.add((IContributionItem)new Separator());
        FillColor dialogColor = new FillColor(CIFillColorConstantsAndMaps.changeFillColorAction.getColor());
        if (!dialogColor.foregroundColor.equalsColor(CIFillColorConstantsAndMaps.INIT_COLOR.foregroundColor)) {
            colorName = ((IAppearanceButtonDecorationWithMenu)CIFillColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText(dialogColor);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CIFillColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage(dialogColor);
            action = new UIChangeAppearanceAction(workbenchPage, "com.arcway.cockpitplanagent.editor.actions.fillcolor.custom", colorName, dialogColor, CIFillColorConstantsAndMaps.APPEARANCE_DECORATION);
            action.setImageDescriptor(imageDescriptor);
            if (enabled) {
                checked = CIFillColor.isActionChecked(dialogColor, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        CIFillColorConstantsAndMaps.changeFillColorAction.setEnabled(enabled);
        CIFillColorConstantsAndMaps.changeFillColorAction.setChecked(false);
        items.add((IContributionItem)new ActionContributionItem((IAction)CIFillColorConstantsAndMaps.changeFillColorAction));
        return items;
    }

    private static SortedMap<String, FillColor> checkForNewColor(ArrayList<Object> selectedStates) {
        TreeMap<String, FillColor> extraColorMaps = new TreeMap<String, FillColor>();
        for (Object state : selectedStates) {
            FillColor color;
            if (!(state instanceof FillColor) || !CIFillColor.isNewColor(color = (FillColor)state)) continue;
            String actionID = "com.arcway.cockpitplanagent.editor.actions.fillcolor" + color.toString();
            extraColorMaps.put(actionID, color);
        }
        return extraColorMaps;
    }

    private static SortedMap<String, FillColor> getUniqueSelectedColor(ArrayList<Object> selectedStates) {
        TreeMap<String, FillColor> uniqueSelectedColor = new TreeMap<String, FillColor>();
        for (Object state : selectedStates) {
            FillColor currentColorOpaque;
            FillColor candidateColor;
            if (!(state instanceof FillColor) || (candidateColor = (FillColor)state).isTransparent()) continue;
            if (uniqueSelectedColor.isEmpty()) {
                String actionID = "com.arcway.cockpitplanagent.editor.actions.fillcolor" + candidateColor.toString();
                uniqueSelectedColor.put(actionID, candidateColor);
                continue;
            }
            Map.Entry entry = uniqueSelectedColor.entrySet().iterator().next();
            FillColor currentColor = (FillColor)entry.getValue();
            FillColor candiateColorOpaque = candidateColor.changeForegroundOpacity(1.0);
            if (candiateColorOpaque.equalsFillColor(currentColorOpaque = currentColor.changeForegroundOpacity(1.0))) continue;
            uniqueSelectedColor.clear();
            break;
        }
        return uniqueSelectedColor;
    }

    private static boolean isActionChecked(FillColor color, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            FillColor selectedColor;
            if (state instanceof FillColor && (checked = color.equalsFillColor(selectedColor = (FillColor)state))) break;
        }
        return checked;
    }

    private static boolean isNewColor(FillColor state) {
        boolean newState = true;
        for (FillColor color : CIFillColorConstantsAndMaps.colorMaps.values()) {
            if (!color.equalsFillColor(state)) continue;
            newState = false;
            break;
        }
        return newState;
    }
}

