/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.actions.UIAlignPlanElementsAction;
import com.arcway.planagent.planeditor.actions.UIClipboardAction;
import com.arcway.planagent.planeditor.actions.UIDeleteAction;
import com.arcway.planagent.planeditor.actions.UIPrintAction;
import com.arcway.planagent.planeditor.actions.UISelectAllAction;
import com.arcway.planagent.planeditor.actions.UIToBackPlanElementsAction;
import com.arcway.planagent.planeditor.actions.UIToBackToContainerPlanElementsAction;
import com.arcway.planagent.planeditor.actions.UIToFrontPlanElementsAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ActionMgr {
    private final IEditorPart facade;
    GraphicalViewer viewer = null;
    private ActionRegistry actionRegistry;
    private final List selectionActions = new ArrayList();
    private final List stackActions = new ArrayList();
    private final List propertyActions = new ArrayList();

    public ActionMgr(IEditorPart facade) {
        assert (facade != null) : "facade is null";
        this.facade = facade;
    }

    public void installActions(int mode) {
        this.createActions(mode);
        this.updatePropertyActions();
        this.updateStackActions();
    }

    public void installViewerActions(int mode, GraphicalViewer newViewer) {
        assert (newViewer != null);
        this.viewer = newViewer;
        this.createViewerActions(mode);
        this.updatePropertyActions();
        this.updateStackActions();
    }

    public void changeMode(int mode) {
    }

    public void removeActions() {
        this.getActionRegistry().dispose();
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    private void createActions(int mode) {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new UndoAction(this.facade);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction(this.facade);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new SaveAction(this.facade);
        registry.registerAction((IAction)action);
        this.getPropertyActions().add(action.getId());
        action = new UIClipboardAction((IWorkbenchPart)this.facade, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UIClipboardAction((IWorkbenchPart)this.facade, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UIClipboardAction((IWorkbenchPart)this.facade, 3);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UIPrintAction((IWorkbenchPart)this.facade);
        registry.registerAction((IAction)action);
        action = new UISelectAllAction((IWorkbenchPart)this.facade);
        registry.registerAction((IAction)action);
        action = new UIDeleteAction((IWorkbenchPart)this.facade);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UIToFrontPlanElementsAction((IWorkbenchPart)this.facade);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UIToBackPlanElementsAction((IWorkbenchPart)this.facade);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UIToBackToContainerPlanElementsAction((IWorkbenchPart)this.facade);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UIAlignPlanElementsAction((IWorkbenchPart)this.facade, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getStackActions().add(action.getId());
        action = new UIAlignPlanElementsAction((IWorkbenchPart)this.facade, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getStackActions().add(action.getId());
        action = new UIAlignPlanElementsAction((IWorkbenchPart)this.facade, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getStackActions().add(action.getId());
        action = new UIAlignPlanElementsAction((IWorkbenchPart)this.facade, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getStackActions().add(action.getId());
        action = new UIAlignPlanElementsAction((IWorkbenchPart)this.facade, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getStackActions().add(action.getId());
        action = new UIAlignPlanElementsAction((IWorkbenchPart)this.facade, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getStackActions().add(action.getId());
    }

    private void createViewerActions(int mode) {
    }

    private List getPropertyActions() {
        return this.propertyActions;
    }

    private List getSelectionActions() {
        return this.selectionActions;
    }

    private List getStackActions() {
        return this.stackActions;
    }

    public void updatePropertyActions() {
        this.updateActions(this.getPropertyActions());
    }

    public void updateStackActions() {
        this.updateActions(this.getStackActions());
    }

    public void updateSelectionActions() {
        this.updateActions(this.getSelectionActions());
    }

    private void updateActions(List actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        Iterator i = actionIds.iterator();
        while (i.hasNext()) {
            IAction action = registry.getAction(i.next());
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }
}

