/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.commands.CommandExecuter;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractUIAction
extends WorkbenchPartAction {
    private ICommandContext commandContext = null;
    private ISelectionProvider provider;
    private Shell shell;

    protected AbstractUIAction(IWorkbenchPart part) {
        super(part);
        this.updateShell(part);
    }

    private void updateShell(IWorkbenchPart part) {
        this.shell = part != null ? part.getSite().getShell() : null;
    }

    protected AbstractUIAction(ContextMenuContext context) {
        super(context.getWorkbenchPart());
        this.shell = context.getWorkbenchPart().getSite().getShell();
        assert (context.getSelectionProvider() != null) : "selectionProvider is null";
        this.setSelectionProvider(context.getSelectionProvider());
    }

    protected AbstractUIAction(ContextMenuContext context, int style) {
        super(context.getWorkbenchPart(), style);
        this.shell = context.getWorkbenchPart().getSite().getShell();
        assert (context.getSelectionProvider() != null) : "selectionProvider is null";
        this.setSelectionProvider(context.getSelectionProvider());
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.provider = provider;
    }

    protected final ISelection getSelection() {
        ISelection selection = this.provider != null ? this.provider.getSelection() : this.getWorkbenchPart().getSite().getWorkbenchWindow().getSelectionService().getSelection();
        return selection;
    }

    protected final List<PEPlanEditPart> getSelectedPEPlanEditParts() {
        ISelection selection = this.getSelection();
        PEPlanEditPartsAndCommandContext pePlanEditPartsAndCommandContext = AbstractUIAction.getSelectedPlanEditPartsAndCommandContext(selection);
        this.commandContext = pePlanEditPartsAndCommandContext.getCommandContext();
        return pePlanEditPartsAndCommandContext.getPePlanEditParts();
    }

    public static List<PEPlanEditPart> getSelectedPEPlanEditParts(ISelection selection) {
        return AbstractUIAction.getSelectedPlanEditPartsAndCommandContext(selection).getPePlanEditParts();
    }

    public static PEPlanEditPartsAndCommandContext getSelectedPlanEditPartsAndCommandContext(ISelection selection) {
        List typedSelectedObjects;
        List selectedObjects = selection instanceof IStructuredSelection ? (typedSelectedObjects = ((IStructuredSelection)selection).toList()) : Collections.emptyList();
        ArrayList<PEPlanEditPart> planEditParts = new ArrayList<PEPlanEditPart>();
        for (Object currentElement : selectedObjects) {
            if (!(currentElement instanceof PEPlanEditPart)) continue;
            planEditParts.add((PEPlanEditPart)currentElement);
        }
        ICommandContext commandContext = null;
        if (!planEditParts.isEmpty()) {
            Iterator iterator = planEditParts.iterator();
            commandContext = ((PEPlanEditPart)iterator.next()).getCommandContext();
            while (iterator.hasNext()) {
                if (((PEPlanEditPart)iterator.next()).getCommandContext() == commandContext) continue;
                planEditParts.clear();
                commandContext = null;
                break;
            }
        }
        return new PEPlanEditPartsAndCommandContext(planEditParts, commandContext);
    }

    protected static <Type> boolean modelListHasOneElementOfType(List<? super Type> list, Class<Type> type) {
        assert (list != null) : "object list is null";
        if (list.size() != 1) {
            return false;
        }
        boolean containsType = false;
        Iterator<Type> i = list.iterator();
        while (!containsType && i.hasNext()) {
            PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)i.next();
            Object modelObject = pEPlanEditPart.getModel();
            containsType |= type.isAssignableFrom(modelObject.getClass());
        }
        return containsType;
    }

    protected ICommandContext getCommandContext() {
        assert (this.commandContext != null) : "getSelectedObjects was not called";
        assert (!this.getSelectedPEPlanEditParts().isEmpty()) : "getSelectedObjects is empty";
        return this.commandContext;
    }

    protected void execute(Command command) {
        this.getShell().setCursor(Cursors.WAIT);
        CommandExecuter.execute(this.getCommandStack(), command);
        this.getShell().setCursor(Cursors.ARROW);
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void setWorkbenchPart(IWorkbenchPart part) {
        super.setWorkbenchPart(part);
        this.updateShell(part);
    }

    public static class PEPlanEditPartsAndCommandContext {
        private final List<PEPlanEditPart> pePlanEditParts;
        private final ICommandContext commandContext;

        private PEPlanEditPartsAndCommandContext(List<PEPlanEditPart> pePlanEditParts, ICommandContext commandContext) {
            this.pePlanEditParts = pePlanEditParts;
            this.commandContext = commandContext;
        }

        public List<PEPlanEditPart> getPePlanEditParts() {
            return this.pePlanEditParts;
        }

        public ICommandContext getCommandContext() {
            return this.commandContext;
        }
    }
}

