/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.geometry.Geo;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Resource;

public class PlanEditorGridLayer
extends GridLayer {
    private static final Color GRID_BG = new Color(null, 255, 255, 255);
    private static final Color GRID_NORMAL;
    private static final Color GRID_STRONG;
    private static final Color GRID_VSTRONG;
    private static final Color GRID_VVSTRONG;
    private static final double MIN_GRID_DISTANCE_IN_PIXELS = 2.1;
    private static final int GRID_LINE_WIDTH = 1;
    private double distanceX = 2.5;
    private double distanceY = 2.5;
    private PrecisionPoint origin = new PrecisionPoint(1.25, 1.25);

    static {
        ResourceDisposer.markResourceAsSingleton((Resource)GRID_BG);
        GRID_NORMAL = new Color(null, 255, 245, 245);
        ResourceDisposer.markResourceAsSingleton((Resource)GRID_NORMAL);
        GRID_STRONG = new Color(null, 250, 235, 235);
        ResourceDisposer.markResourceAsSingleton((Resource)GRID_STRONG);
        GRID_VSTRONG = new Color(null, 250, 220, 220);
        ResourceDisposer.markResourceAsSingleton((Resource)GRID_VSTRONG);
        GRID_VVSTRONG = new Color(null, 250, 200, 200);
        ResourceDisposer.markResourceAsSingleton((Resource)GRID_VVSTRONG);
    }

    public PlanEditorGridLayer() {
        this.setOpaque(true);
        this.setBackgroundColor(GRID_BG);
        this.setForegroundColor(GRID_NORMAL);
        this.origin = new PrecisionPoint();
    }

    public void setSpacing(Dimension spacingIn) {
        Dimension spacing = spacingIn != null ? spacingIn : new Dimension(12, 12);
        if (spacing instanceof PrecisionDimension) {
            PrecisionDimension precisionSpacing = (PrecisionDimension)spacing;
            this.distanceX = Geo.equals((double)precisionSpacing.preciseWidth, (double)0.0) ? this.distanceX : precisionSpacing.preciseWidth;
            this.distanceY = Geo.equals((double)precisionSpacing.preciseHeight, (double)0.0) ? this.distanceY : precisionSpacing.preciseHeight;
            this.repaint();
        } else if (!spacing.equals(this.gridX, this.gridY)) {
            this.gridX = spacing.width == 0 ? this.gridX : spacing.width;
            this.gridY = spacing.height == 0 ? this.gridY : spacing.height;
            this.repaint();
        }
    }

    protected void paintGrid(Graphics g) {
        PrecisionRectangle clip = new PrecisionRectangle(g.getClip(Rectangle.SINGLETON));
        clip.updateInts();
        this.drawAllLinesModulo(0.2, GRID_NORMAL, g, clip);
        this.drawAllLinesModulo(1.0, GRID_STRONG, g, clip);
        this.drawAllLinesModulo(2.0, GRID_VSTRONG, g, clip);
        this.drawAllLinesModulo(20.0, GRID_VVSTRONG, g, clip);
    }

    private void drawAllLinesModulo(double modulo, Color color, Graphics g, PrecisionRectangle clip) {
        double stepY;
        double stepX = this.distanceX * modulo;
        if (stepX > 2.1) {
            double startX;
            double x = startX = this.getNextGridGuide(this.origin.preciseX, stepX, clip.preciseX - 1.0);
            while (x <= clip.preciseX + clip.preciseWidth + 1.0 + 1.0E-10) {
                g.setForegroundColor(color);
                g.setLineWidth(1);
                g.drawLine((int)Math.round(x), (int)Math.floor(clip.preciseY - 1.0E-10), (int)Math.round(x), (int)Math.ceil(clip.preciseY + clip.preciseHeight + 1.0E-10));
                x += stepX;
            }
        }
        if ((stepY = this.distanceY * modulo) > 2.1) {
            double startY;
            double y = startY = this.getNextGridGuide(this.origin.preciseY, stepY, clip.preciseY - 1.0);
            while (y <= clip.preciseY + clip.preciseHeight + 1.0E-10 + 1.0) {
                g.setForegroundColor(color);
                g.setLineWidth(1);
                g.drawLine((int)Math.floor(clip.preciseX - 1.0E-10), (int)Math.round(y), (int)Math.ceil(clip.preciseX + clip.preciseWidth + 1.0E-10), (int)Math.round(y));
                y += stepY;
            }
        }
    }

    private double getNextGridGuide(double gridOrigin, double gridDistance, double clipPoint) {
        double distanceToOrigin = clipPoint - gridOrigin;
        double rest = distanceToOrigin % gridDistance;
        double nextGuide = Geo.equals((double)rest, (double)0.0) ? clipPoint : (rest > 0.0 ? clipPoint - rest + gridDistance : clipPoint - rest);
        return nextGuide;
    }
}

