/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.IInternalAbstractPlanAgent;
import com.arcway.planagent.IInternalUpdatedPlanAgentExtension;
import com.arcway.planagent.UpdatedAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgentController;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentExtension;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInput;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.planeditor.IHelpContextIDs;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.PlanEditor;
import com.arcway.planagent.planeditor.PlanEditorFacadeInput;
import com.arcway.planagent.planeditor.edit.IEditorSpecialEventHandler;
import com.arcway.planagent.planeditor.inputinterpreter.IInputContext;
import com.arcway.planagent.planeditor.standalone.StandalonePlanEditorController;
import com.arcway.planagent.planeditor.standalone.StandalonePlanEditorControllerExtension;
import com.arcway.planagent.planeditor.standalone.StandalonePlanInfo;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.util.gui.MultiStepProcessor;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class PlanEditorFacade
extends EditorPart
implements IPlanAgent,
IInputContext,
IEditorSpecialEventHandler {
    private static final ILogger logger = Logger.getLogger(PlanEditorFacade.class);
    private boolean wasModified;
    private boolean editorSaving;
    private Image createdTitleImage = null;
    private String fallBackPartName = "";
    private UpdatedAbstractPlanAgent abstractPlanAgent;
    private PlanEditor planEditor;
    private IPlanEditorControllerExtension planEditorControllerExtension;
    private Composite helpContextComposite;

    /*
     * Unable to fully structure code
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        block15: {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            if (input instanceof PlanEditorFacadeInput) {
                try {
                    facadeInput = (PlanEditorFacadeInput)input;
                    this.checkForConcurrentEditors(facadeInput);
                    this.fallBackPartName = facadeInput.getPlanAgentInput().getPlanFile().getName();
                    oldcreatedTitleImage = this.createdTitleImage;
                    this.createdTitleImage = facadeInput.getImageDescriptor().createImage();
                    this.setTitleImage(this.createdTitleImage);
                    if (oldcreatedTitleImage != null) {
                        oldcreatedTitleImage.dispose();
                    }
                    this.planEditorControllerExtension = facadeInput.getControllerExtension();
                    initialMode = 0;
                    switch (facadeInput.getEditorExtensionInput().getInitMode()) {
                        case 3: {
                            initialMode = 3;
                            break;
                        }
                        default: {
                            initialMode = 1;
                        }
                    }
                    this.abstractPlanAgent = new UpdatedAbstractPlanAgent(facadeInput.getPlanAgentInput());
                    this.planEditor = new PlanEditor((IInternalAbstractPlanAgent)this.abstractPlanAgent, this.planEditorControllerExtension, initialMode, facadeInput.getProgressDisplay(), this);
                    this.abstractPlanAgent.setPlanAgentExtension((IInternalUpdatedPlanAgentExtension)this.planEditor);
                    this.planEditor.setup();
                    break block15;
                }
                catch (EXSetupPlanException e) {
                    PlanEditorFacade.logger.error("plan setup failed", (Throwable)e);
                    causeBuilder = new StringBuilder(e.getMessage());
                    i = e;
                    ** while (i != null && i.getCause() != i)
                }
lbl-1000:
                // 1 sources

                {
                    if ((i = i.getCause()) == null) continue;
                    causeBuilder.append(" ");
                    causeBuilder.append(i.getMessage());
                    continue;
                }
lbl37:
                // 1 sources

                throw new PartInitException(causeBuilder.toString(), (Throwable)e);
            }
            if (input instanceof IPathEditorInput) {
                try {
                    fileEditorInput = (IPathEditorInput)input;
                    this.fallBackPartName = fileEditorInput.getName();
                    initialMode = fileEditorInput.getPath().toFile().canWrite() != false ? 1 : 3;
                    planInfo = new StandalonePlanInfo(fileEditorInput);
                    controller = new StandalonePlanEditorController();
                    pai = new PlanAgentInput(null, null, fileEditorInput.getPath().toFile(), (IPlanInfo)planInfo, (IAbstractPlanAgentController)controller);
                    this.abstractPlanAgent = new UpdatedAbstractPlanAgent(pai);
                    this.planEditorControllerExtension = new StandalonePlanEditorControllerExtension(site, fileEditorInput, this.abstractPlanAgent);
                    this.abstractPlanAgent.loadPlan(IProgressDisplay.DUMMY);
                    planType = this.abstractPlanAgent.getPlan().getType();
                    try {
                        imageURL = PlanAgentExtensionMgr.getDefault().getPlanIconForType(planType);
                        titleImageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
                        if (titleImageDescriptor != null && (titleImage = titleImageDescriptor.createImage()) != null) {
                            this.setTitleImage(titleImage);
                        }
                    }
                    catch (EXPlanTypeUnknown var10_20) {
                        // empty catch block
                    }
                    this.planEditor = new PlanEditor((IInternalAbstractPlanAgent)this.abstractPlanAgent, this.planEditorControllerExtension, initialMode, IProgressDisplay.DUMMY, this);
                    this.abstractPlanAgent.setPlanAgentExtension((IInternalUpdatedPlanAgentExtension)this.planEditor);
                    this.planEditor.setup();
                    controller.setup(fileEditorInput, this, this.abstractPlanAgent);
                    break block15;
                }
                catch (EXSetupPlanException e) {
                    PlanEditorFacade.logger.error("plan setup failed", (Throwable)e);
                    causeBuilder = new StringBuilder(e.getMessage());
                    i = e;
                    ** while (i.getCause() != null && i.getCause() != i)
                }
lbl-1000:
                // 1 sources

                {
                    i = i.getCause();
                    causeBuilder.append(" ");
                    causeBuilder.append(i.getMessage());
                    continue;
                }
lbl75:
                // 1 sources

                throw new PartInitException(causeBuilder.toString(), (Throwable)e);
            }
            throw new PartInitException("Unknown input type: " + input.getClass().getName());
        }
        this.setPartName(this.suggestPartName());
    }

    private void checkForConcurrentEditors(PlanEditorFacadeInput input) throws PartInitException {
        if (input.getController() == null) {
            throw new PartInitException(Messages.getString("PlanEditorFacade.Reopen"));
        }
        int openEditorsForThisInput = 0;
        IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorInput otherEditorInput = editorReference.getEditorInput();
            if (otherEditorInput == input) {
                ++openEditorsForThisInput;
            }
            ++n2;
        }
        if (openEditorsForThisInput > 1) {
            throw new PartInitException(Messages.getString("PlanEditorFacade.Duplicate"));
        }
    }

    public void doSave(final IProgressMonitor monitor) {
        this.editorSaving = true;
        this.planEditorControllerExtension.doSaveTransaction(new Runnable(){

            @Override
            public void run() {
                Object progressDisplay = monitor == null ? IProgressDisplay.DUMMY : new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                MultiStepProcessor.ISubTask editorSaver = new MultiStepProcessor.ISubTask(){

                    public int getWeight() {
                        return 50;
                    }

                    public void process(IProgressDisplay subTaskProgressDisplay) throws Exception {
                        PlanEditorFacade.this.abstractPlanAgent.savePlan(subTaskProgressDisplay);
                    }

                    public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                        return null;
                    }
                };
                MultiStepProcessor.ISubTask controllerSaver = new MultiStepProcessor.ISubTask(){

                    public int getWeight() {
                        return 50;
                    }

                    public void process(IProgressDisplay subProgressDisplay) {
                        PlanEditorFacade.this.planEditorControllerExtension.save(subProgressDisplay);
                    }

                    public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                        return null;
                    }
                };
                MultiStepProcessor.ISubTask[] subTasks = new MultiStepProcessor.ISubTask[]{editorSaver, controllerSaver};
                try {
                    String planName = PlanEditorFacade.this.abstractPlanAgent.getPlanInfo().getPlanName();
                    String whatToDo = planName == null ? String.valueOf(Messages.getString("PlanEditorFacade.Saving")) + "..." : String.valueOf(Messages.getString("PlanEditorFacade.Saving")) + " " + planName + "...";
                    MultiStepProcessor.process((String)whatToDo, (MultiStepProcessor.ISubTask[])subTasks, (IProgressDisplay)progressDisplay);
                    PlanEditorFacade.this.planEditor.markSaveLocation();
                }
                catch (Exception e) {
                    if (monitor != null) {
                        monitor.setCanceled(true);
                    }
                    logger.error("Exeption during saving plan file " + PlanEditorFacade.this.getTitle(), (Throwable)e);
                }
            }
        });
        if (this.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)this.getEditorInput();
            IFile file = fileEditorInput.getFile();
            try {
                file.refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.fireModifiedChange();
        this.editorSaving = false;
    }

    public void setInput(IEditorInput input) {
        if (input != this.getEditorInput()) {
            this.destroyEditorInput();
        }
        super.setInput(input);
    }

    private void destroyEditorInput() {
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && oldInput instanceof PlanEditorFacadeInput) {
            ((PlanEditorFacadeInput)oldInput).destroy();
        }
    }

    public void doSaveAs() {
        if (this.planEditorControllerExtension.isSaveAsAllowed()) {
            IEditorInput newInput = this.planEditorControllerExtension.saveAsRequest();
            super.setInput(newInput);
            this.refreshPartName();
            this.planEditor.getCommandStack().markSaveLocation();
        }
    }

    public boolean isSaveAsAllowed() {
        return this.planEditorControllerExtension.isSaveAsAllowed();
    }

    public boolean isDirty() {
        boolean isDirrrrrty = false;
        if (this.planEditor != null) {
            isDirrrrrty = this.planEditor.isDirty();
        }
        return isDirrrrrty;
    }

    public void createPartControl(Composite parent) {
        this.helpContextComposite = parent;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.helpContextComposite, IHelpContextIDs.EDITOR_INDEX);
        if (this.planEditor != null) {
            this.planEditor.createPartControl(parent);
        }
    }

    public void setFocus() {
        this.helpContextComposite.setFocus();
    }

    public Object getAdapter(Class type) {
        Object adapter = this.planEditor.getAdapter(type);
        if (adapter == null) {
            adapter = super.getAdapter(type);
        }
        return adapter;
    }

    private String suggestPartName() {
        String partName;
        IPlanInfo planInfo = this.abstractPlanAgent.getPlanInfo();
        if (planInfo != null) {
            partName = planInfo.getPlanName();
            Boolean isCurrentVersion = planInfo.isCurrentVersion();
            String version = planInfo.getVersion();
            if (isCurrentVersion != null && !isCurrentVersion.booleanValue() && version != null) {
                partName = String.valueOf(partName) + " (" + version + ")";
            }
        } else {
            partName = this.planEditor.getPlan().getName();
            if ("".equals(partName)) {
                partName = this.fallBackPartName;
            }
            if ("".equals(partName)) {
                partName = "unknown";
            }
        }
        if (this.getEditorInput() instanceof PlanEditorFacadeInput && this.planEditor.getWorkingMode() == 1) {
            partName = String.valueOf(partName) + Messages.getString("PlanEditor.(edit_mode)");
        }
        return partName;
    }

    void fireModifiedChange() {
        boolean isModified = this.isDirty();
        if (isModified != this.wasModified) {
            this.firePropertyChange(257);
            this.wasModified = isModified;
        }
    }

    void refreshPartName() {
        this.setPartName(this.suggestPartName());
        this.firePropertyChange(1);
    }

    @Override
    public Shell getShell() {
        return this.getEditorSite().getShell();
    }

    public IAbstractPlanAgent getAbstractPlanAgent() {
        return this.abstractPlanAgent;
    }

    public IPlanAgentExtension getPlanAgentExtension() {
        return this.planEditor;
    }

    public void dispose() {
        if (this.planEditor != null) {
            this.planEditor.dispose();
        }
        super.dispose();
        this.destroyEditorInput();
        if (this.createdTitleImage != null) {
            this.createdTitleImage.dispose();
        }
    }

    public boolean isSaving() {
        return this.editorSaving;
    }

    public CommandStack getCommandStack() {
        return this.planEditor.getCommandStack();
    }
}

