/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.PlanAgentTimestamp;
import com.arcway.planagent.planeditor.PATCHED_DeferredUpdateManager;
import com.arcway.planagent.planeditor.edit.EditMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PATCHED_ScrollingGraphicalViewer
extends GraphicalViewerImpl {
    private static final ILogger logger = Logger.getLogger(PATCHED_ScrollingGraphicalViewer.class);
    protected List pendingOldSelection = null;
    protected IFigure rootFigure;
    private boolean createNewTimestamp = true;
    private EditMgr editMgr = null;
    private PlanAgentTimestamp timestamp = new PlanAgentTimestamp();

    public void appendSelection(Collection editParts) {
        this.storeOldSelection();
        boolean focusPartFound = false;
        EditPart focus = this.getFocusEditPart();
        List list = this.primGetSelectedEditParts();
        if (!list.isEmpty()) {
            EditPart primary = (EditPart)list.get(list.size() - 1);
            primary.setSelected(1);
        }
        Iterator i = editParts.iterator();
        while (i.hasNext()) {
            EditPart editPart = (EditPart)i.next();
            if (editPart == focus) {
                focusPartFound |= true;
            }
            if (list.contains(editPart)) {
                list.remove(editPart);
            }
            list.add(editPart);
            if (i.hasNext()) {
                editPart.setSelected(1);
                continue;
            }
            editPart.setSelected(2);
        }
        if (focusPartFound) {
            this.setFocus(null);
        }
        this.fireSelectionChanged();
    }

    public void appendSelection(EditPart editpart) {
        this.storeOldSelection();
        super.appendSelection(editpart);
    }

    public final Control createControl(Composite parent) {
        FigureCanvas canvas = new FigureCanvas(parent, this.getLightweightSystem());
        canvas.setHorizontalScrollBarVisibility(FigureCanvas.ALWAYS);
        canvas.setVerticalScrollBarVisibility(FigureCanvas.ALWAYS);
        super.setControl((Control)canvas);
        this.installRootFigure();
        return canvas;
    }

    public void deselect(Collection editParts) {
        this.storeOldSelection();
        List selectedEditParts = this.primGetSelectedEditParts();
        for (EditPart editPart : editParts) {
            editPart.setSelected(0);
            selectedEditParts.remove(editPart);
        }
        if (!selectedEditParts.isEmpty()) {
            EditPart primary = (EditPart)selectedEditParts.get(selectedEditParts.size() - 1);
            primary.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    public void deselect(EditPart editpart) {
        this.storeOldSelection();
        super.deselect(editpart);
    }

    public void deselectAll() {
        this.storeOldSelection();
        super.deselectAll();
    }

    public void deselectAllFromMachine() {
        boolean oldCreateNewTimestamp = this.createNewTimestamp;
        this.createNewTimestamp = false;
        this.deselectAll();
        this.createNewTimestamp = oldCreateNewTimestamp;
    }

    public void fireSelectionChanged() {
        if (this.createNewTimestamp) {
            this.timestamp = new PlanAgentTimestamp();
        }
        if (this.hasSelectionChangedAndClearOldSelection() || this.getSelectedEditParts().isEmpty()) {
            if (logger.isDebugEnabled(69)) {
                logger.debug(69, ">>>>>>>>>> Graphical Viewer: fire selection changed <<<<<<<<");
                Iterator i = this.getSelectedEditParts().iterator();
                while (i.hasNext()) {
                    logger.debug(69, ">>>>>>>>>> " + i.next());
                }
            }
            super.fireSelectionChanged();
        }
    }

    public EditMgr getEditMgr() {
        return this.editMgr;
    }

    public PlanAgentTimestamp getTimestamp() {
        return this.timestamp;
    }

    public void reveal(EditPart part) {
        super.reveal(part);
        Viewport port = this.getFigureCanvas().getViewport();
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getCopy();
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        exposeRegion.expand(5, 5);
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = Point.min((Point)topLeft, (Point)Point.max((Point)bottomRight, (Point)port.getViewLocation()));
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    public void select(EditPart editpart) {
        this.storeOldSelection();
        super.select(editpart);
    }

    public void setContents(EditPart editpart) {
        this.storeOldSelection();
        super.setContents(editpart);
    }

    public void setEditMgr(EditMgr editMgr) {
        assert (editMgr != null);
        this.editMgr = editMgr;
    }

    public void setSelection(ISelection newSelection) {
        this.setSelectionWithoutFiringSelectionChanged(newSelection);
        this.fireSelectionChanged();
    }

    public void setSelectionWithoutFiringSelectionChanged(ISelection newSelection) {
        if (!(newSelection instanceof IStructuredSelection)) {
            return;
        }
        this.storeOldSelection();
        List editparts = ((IStructuredSelection)newSelection).toList();
        List selectedEditParts = this.primGetSelectedEditParts();
        this.setFocus(null);
        int i = 0;
        while (i < selectedEditParts.size()) {
            ((EditPart)selectedEditParts.get(i)).setSelected(0);
            ++i;
        }
        selectedEditParts.clear();
        selectedEditParts.addAll(editparts);
        i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (i == editparts.size() - 1) {
                part.setSelected(2);
            } else {
                part.setSelected(1);
            }
            ++i;
        }
    }

    protected LightweightSystem createLightweightSystem() {
        LightweightSystem lightweightSystem = new LightweightSystem();
        lightweightSystem.setUpdateManager((UpdateManager)new PATCHED_DeferredUpdateManager());
        return lightweightSystem;
    }

    protected FigureCanvas getFigureCanvas() {
        return (FigureCanvas)this.getControl();
    }

    protected void setRootFigure(IFigure figure) {
        this.rootFigure = figure;
        this.installRootFigure();
    }

    private boolean hasSelectionChangedAndClearOldSelection() {
        boolean hasChanged;
        List currentSelection = this.primGetSelectedEditParts();
        List oldSelection = this.pendingOldSelection;
        if (oldSelection == null || currentSelection == null) {
            hasChanged = oldSelection != currentSelection;
        } else {
            boolean bl = hasChanged = oldSelection.size() != currentSelection.size();
            if (!hasChanged) {
                int size = oldSelection.size();
                int i = 0;
                while (!hasChanged && i < size) {
                    hasChanged |= oldSelection.get(i) != currentSelection.get(i);
                    ++i;
                }
            }
        }
        this.pendingOldSelection = null;
        return hasChanged;
    }

    private void installRootFigure() {
        if (this.getFigureCanvas() == null) {
            return;
        }
        if (this.rootFigure instanceof Viewport) {
            this.getFigureCanvas().setViewport((Viewport)this.rootFigure);
        } else {
            this.getFigureCanvas().setContents(this.rootFigure);
        }
    }

    private void storeOldSelection() {
        if (this.pendingOldSelection == null) {
            this.pendingOldSelection = new ArrayList(this.primGetSelectedEditParts());
        }
    }
}

