/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.IPlanEditorConfig;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionMgr {
    private static final String PLAN_EDITOR_CONFIG_EXTENSION_ID = "planeditorconfig";
    private static final String PLAN_EDITOR_CONFIG_ELEMENT = "planeditorconfig";
    private static final String PLAN_EDITOR_CONFIG_ATTRIBUTE_PLANTYPE = "plantypeID";
    private static final String PLAN_EDITOR_CONFIG_ATTRIBUTE_CONFIG = "config";
    private Map<String, IPlanEditorConfig> editorConfig;
    private static final ExtensionMgr singelton = new ExtensionMgr();
    private static IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();

    private static String getPlugInID() {
        return FMCAPlanEditorPlugin.getPluginID();
    }

    private ExtensionMgr() {
    }

    public static ExtensionMgr getDefault() {
        return singelton;
    }

    public IPlanEditorConfig getPlanEditorConfigForPlanType(String planTypeID) {
        if (this.editorConfig == null) {
            IExtension[] allExtensions;
            this.editorConfig = new HashMap<String, IPlanEditorConfig>();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(ExtensionMgr.getPlugInID(), "planeditorconfig");
            assert (extensionPoint != null) : "No extension point found.";
            IExtension[] iExtensionArray = allExtensions = extensionPoint.getExtensions();
            int n = allExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (currentConfigElement.getName().equals("planeditorconfig")) {
                        try {
                            String planType = currentConfigElement.getAttribute(PLAN_EDITOR_CONFIG_ATTRIBUTE_PLANTYPE);
                            IPlanEditorConfig extension = (IPlanEditorConfig)currentConfigElement.createExecutableExtension(PLAN_EDITOR_CONFIG_ATTRIBUTE_CONFIG);
                            this.editorConfig.put(planType, extension);
                        }
                        catch (CoreException e) {
                            FMCAPlanEditorPlugin.getDefault().getLog().log(e.getStatus());
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.editorConfig.get(planTypeID);
    }
}

