/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planeditor.IActionParameterListener;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.anchoring.IAnchoringContext;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.ui.PlatformUI;

public class ActionParameterStorage
implements IAnchoringContext,
IRoutingParameters {
    private static final double ANCHORING_TOLERANCE = 3.0;
    private static final String IS_BENDING_INACTIVE_PREFERENCE_KEY = "com.arcway.planagent.planeditor.actionparameters.isbendinginactive";
    private static ActionParameterStorage singeltonInstance = null;
    private final ActionParameters actionParameters;
    private boolean isBendingActive;
    private final Collection<IActionParameterListener> parameterListener = new ArrayList<IActionParameterListener>();

    public static synchronized ActionParameterStorage getInstance() {
        if (singeltonInstance == null) {
            singeltonInstance = new ActionParameterStorage();
        }
        return singeltonInstance;
    }

    private ActionParameterStorage() {
        this.actionParameters = new ActionParameters((IAnchoringContext)this, (IRoutingParameters)this);
        this.isBendingActive = !PlatformUI.getPreferenceStore().getBoolean(IS_BENDING_INACTIVE_PREFERENCE_KEY);
    }

    public ActionParameters getActionParameters() {
        return this.actionParameters;
    }

    public double getAnchoringTolerance() {
        return 3.0;
    }

    public boolean isBendingActive() {
        return this.isBendingActive;
    }

    public GeoVector getDistanceWhenFiguresAreMoved(IPMFigureRW movedFigure) {
        return null;
    }

    public void addParameterListener(IActionParameterListener listener) {
        assert (listener != null) : "listener is null";
        this.parameterListener.add(listener);
    }

    public boolean removeParameterListener(IActionParameterListener listener) {
        assert (listener != null) : "listener is null";
        return this.parameterListener.remove(listener);
    }

    public void setIsBendingActive(boolean state) {
        this.isBendingActive = state;
        PlatformUI.getPreferenceStore().setValue(IS_BENDING_INACTIVE_PREFERENCE_KEY, !state);
        this.callListeners();
    }

    private void callListeners() {
        Iterator<IActionParameterListener> iterator = this.parameterListener.iterator();
        while (iterator.hasNext()) {
            IActionParameterListener iActionParameterListener;
            IActionParameterListener listener = iActionParameterListener = iterator.next();
            listener.actionParameterChanged(this.getActionParameters());
        }
    }
}

