/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.gui.edit;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planeditor.base.edit.IPEPlanElementWithCommentSupplement;
import com.arcway.planagent.planeditor.base.edit.PEPlanElementWithOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planeditor.base.inputinterpreter.EPEditNameOnPlanElement;
import com.arcway.planagent.planeditor.cm.inputinterpreter.EPDeleteCommentTextOnSupplement;
import com.arcway.planagent.planeditor.cm.inputinterpreter.EPEditCommentTextOnSupplement;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlanObject;
import com.arcway.planagent.planeditor.gui.edit.PEGraphicalSupplementGUIGroupGraphic;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.appearance.TemplateApplicationTuple;
import com.arcway.planagent.planmodel.gui.access.readonly.IPMPlanElementGUIGroupRO;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gef.EditPolicy;

public class PEPlanElementGUIGroup
extends PEPlanElementWithOutlineAndNameAndDescriptionSupplement
implements IPEPlanElementWithCommentSupplement {
    private static final double DEFAULT_COMMENT_WIDTH = 30.0;
    private static final double DEFAULT_NAME_HEIGHT = 10.0;
    private static final double DEFAULT_NAME_INDENTION = 2.5;

    protected void createEditPolicies() {
        super.createEditPolicies();
        switch (this.getPEPlan().getMode()) {
            case 1: {
                this.installEditPolicy("planelement_edit_role", (EditPolicy)new EPEditNameOnPlanElement());
                this.installEditPolicy("commentsupplement_edit_role", (EditPolicy)new EPEditCommentTextOnSupplement());
                this.installEditPolicy("DELETE_COMMENT_ROLE", (EditPolicy)new EPDeleteCommentTextOnSupplement());
                break;
            }
            case 3: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public PEFigure getEditFigure() {
        return this.getOutlineFigure();
    }

    public Points getDefaultCommentArea() {
        Rectangle bounds = this.getPMPlanElementFMCWithOutline().getOutlineFigureRO().getPointListRO().getPoints().getBounds();
        Point lowerRight = bounds.lowerRight;
        double height = bounds.h();
        Points geometry = new Points();
        geometry.add(lowerRight);
        geometry.add(new Point(lowerRight.x, lowerRight.y - height));
        geometry.add(new Point(lowerRight.x + 30.0, lowerRight.y - height));
        geometry.add(new Point(lowerRight.x + 30.0, lowerRight.y));
        return geometry;
    }

    public Points getDefaultNameSupplementTextArea() {
        Rectangle bounds = this.getPMPlanElementFMCWithOutline().getOutlineFigureRO().getPointListRO().getPoints().getBounds();
        Points geometry = new Points();
        geometry.add(new Point(bounds.upperLeft.x + 2.5, bounds.upperLeft.y - 5.0));
        geometry.add(new Point(bounds.upperLeft.x + 2.5, bounds.upperLeft.y + 5.0));
        geometry.add(new Point(bounds.lowerRight.x, bounds.upperLeft.y + 5.0));
        geometry.add(new Point(bounds.lowerRight.x, bounds.upperLeft.y - 5.0));
        return geometry;
    }

    public Collection<TemplateApplicationTuple> getTemplateApplicationTuples() {
        Collection superTuples = super.getTemplateApplicationTuples();
        ArrayList<TemplateApplicationTuple> tuples = new ArrayList<TemplateApplicationTuple>(superTuples.size() - 1);
        IPMFigurePlaneRO outline = ((IPMPlanElementGUIGroupRO)this.getPMPlanElement()).getOutlineFigurePlaneRO();
        for (TemplateApplicationTuple singleTuple : superTuples) {
            if (singleTuple.getPlanObject() == outline && singleTuple.getAppearance() == outline.getLineAppearanceRO()) continue;
            tuples.add(singleTuple);
        }
        return tuples;
    }

    protected boolean isGraphicalSupplementSelectable(PEGraphicalSupplement graphicalSupplement) {
        if (graphicalSupplement instanceof PEGraphicalSupplementGUIGroupGraphic) {
            return false;
        }
        return super.isGraphicalSupplementSelectable(graphicalSupplement);
    }

    public boolean provideAppearancesFor(PEPlanObject child) {
        if (child instanceof PEGraphicalSupplementGUIGroupGraphic) {
            return true;
        }
        return super.provideAppearancesFor(child);
    }
}

