/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.fmc.bd.commands;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planeditor.fmc.bd.Messages;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.fmc.bd.access.readwrite.IPMPlanElementFMCBDChannelRW;
import com.arcway.planagent.planmodel.fmc.bd.appearance.FMCBDRequestSymbolAppearance;
import com.arcway.planagent.planmodel.fmc.bd.appearance.IFMCBDRequestSymbolAppearanceRO;
import com.arcway.planagent.planmodel.fmc.bd.transactions.TACreateFMCBDRequestSymbol;
import com.arcway.planagent.planmodel.transactions.Transaction;

public class CMCreateRequestSymbol
extends TransactionCommand {
    private static final String COMMAND_LABEL = Messages.getString("CMCreateRequestSymbol.Create_Request_Symbol");
    private static final double REQUEST_SYMBOL_DISTANCE = 2.5;

    public CMCreateRequestSymbol(IPMPlanElementFMCBDChannelRW channel, ICommandContext commandContext) {
        super(commandContext);
        double y;
        double x;
        assert (channel != null) : "channel is null";
        assert (channel.getRequestSymbolRW() == null) : "channel already has a request symbol";
        IPMFigurePlaneRW outlineFigure = channel.getOutlineFigurePlaneRW();
        Rectangle bounds = outlineFigure.getPointListRW().getPoints().getBounds();
        boolean isVertical = CMCreateRequestSymbol.isVertical(outlineFigure);
        FMCBDRequestSymbolAppearance symbolApperance = new FMCBDRequestSymbolAppearance();
        if (isVertical) {
            symbolApperance.setDirection(Direction.ANGLE_270);
            x = bounds.lowerRight.x + 2.5;
            y = bounds.center().y;
        } else {
            symbolApperance.setDirection(Direction.ANGLE_0);
            x = bounds.center().x;
            y = bounds.upperLeft.y - 2.5;
        }
        Points geometry = new Points();
        geometry.add(new Point(x, y));
        TACreateFMCBDRequestSymbol transaction = new TACreateFMCBDRequestSymbol(channel, this.getActionParameters(), geometry, (IFMCBDRequestSymbolAppearanceRO)symbolApperance);
        super.construct(COMMAND_LABEL, (Transaction)transaction);
    }

    private static boolean isVertical(IPMFigurePlaneRW outlineFigure) {
        int verticals = 0;
        int horizontals = 0;
        int i = 0;
        while (i < outlineFigure.getAnchoringCount()) {
            IPMAnchoringPointToFigureRW anchoring = outlineFigure.getAnchoringRW(i);
            IPMPointRW point = anchoring.getPointRW();
            IPMLineRW line = point.getLine1stRW();
            if (line == null) {
                line = point.getLine2ndRW();
            }
            if (line != null) {
                if (line.getForce() == 2) {
                    ++horizontals;
                } else if (line.getForce() == 3) {
                    ++verticals;
                }
            }
            ++i;
        }
        return verticals > horizontals;
    }
}

