/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.fmc.bd.check;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.ImagePrinter;
import com.arcway.lib.graphics.print.ImagePrinterPageDescription;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import com.arcway.planagent.planeditor.check.DefaultProblemDialog;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.fmc.bd.Messages;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planview.print.PrintProcessor;
import com.arcway.planagent.planview.view.PVView;
import com.arcway.planagent.planview.viewcreator.ViewCreator;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GraphicalProblemDialog
extends DefaultProblemDialog {
    private static ILogger logger = Logger.getLogger(GraphicalProblemDialog.class);
    private static final int IMAGE_HEIGHT_MM = 100;
    private static final int IMAGE_WIDTH_MM = 60;
    Collection involvedElements = null;

    public GraphicalProblemDialog(Shell parentShell, String shortDesc, String desc, Collection involvedElements) {
        super(parentShell, shortDesc, desc);
        this.involvedElements = involvedElements;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(String.valueOf(Messages.getString("GraphicalProblemDialog.Problem")) + " " + this.shortDesc);
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        layout.marginWidth = 10;
        topLevel.setLayout((Layout)layout);
        ImagePrinter printer = new ImagePrinter(ImagePrinterPageDescription.createImageInfoInMM((double)100.0, (double)60.0, (double)0.0, (double)EditMgr.DPI_X, (double)EditMgr.DPI_Y, (Color)Color.WHITE));
        try {
            PageSetup pc = new PageSetup(1, 1, new Alignment(), 1.0, true, true, new Insets(5.0, 5.0, 5.0, 5.0));
            PrintProcessor pp = new PrintProcessor();
            IPMPlanElementRW firstPlanElement = (IPMPlanElementRW)this.involvedElements.iterator().next();
            IPMPlanRO plan = (IPMPlanRO)firstPlanElement.getPlanRW().getCopyRW(this.involvedElements, new HashMap());
            ViewCreator creator = new ViewCreator();
            PVView pvView = creator.createPVView((Object)plan, null, null, true, HighlightLevel.SYNTAX_CHECK, false, false);
            pp.print((IPrinter)printer, pvView, pc, plan.getName());
            Image imagewrapper = (Image)printer.getCreatedImages().iterator().next();
            final org.eclipse.swt.graphics.Image img = ((SWTOffscreenBitmap)imagewrapper.getOffscreenBitmap()).getWrappedSWTImage();
            Composite c = new Composite(topLevel, 2048);
            GridData data = new GridData();
            data.widthHint = img.getBounds().width;
            data.heightHint = img.getBounds().height;
            c.setLayoutData((Object)data);
            c.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.drawImage(img, 0, 0);
                }
            });
            Label text = new Label(topLevel, 64);
            data = new GridData();
            data.widthHint = img.getBounds().width / 3 * 2;
            data.heightHint = img.getBounds().height;
            text.setLayoutData((Object)data);
            text.setText(this.desc);
        }
        catch (Exception e) {
            logger.error("Could not create error dialog", (Throwable)e);
        }
        return topLevel;
    }
}

