/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.lib.graphics.Color;
import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import com.arcway.planagent.planeditor.cm.actions.CITextColorConstantsAndMaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class CITextColor
extends MenuContributionItem {
    private Map<String, Color> extraColorMaps;

    public CITextColor() {
    }

    public CITextColor(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected IAppearanceButtonDecoration getButtonType() {
        return CITextColorConstantsAndMaps.APPEARANCE_DECORATION;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] colorItems = items.toArray(new IContributionItem[items.size()]);
        return colorItems;
    }

    private ArrayList<IContributionItem> constructContributionItem() {
        UIChangeAppearanceAction action;
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        CITextColorConstantsAndMaps.changeColorAction.init(workbenchPage);
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, CITextColorConstantsAndMaps.INIT_COLOR);
        boolean checked = false;
        ArrayList selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (String actionID : CITextColorConstantsAndMaps.sortedColorIDList) {
            Color color = CITextColorConstantsAndMaps.colorMaps.get(actionID);
            String colorName = ((IAppearanceButtonDecorationWithMenu)CITextColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText((Object)color);
            action = new UIChangeAppearanceAction(workbenchPage, actionID, colorName, (Object)color, CITextColorConstantsAndMaps.APPEARANCE_DECORATION);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CITextColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage((Object)color);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            if (enabled) {
                checked = this.isActionChecked(color, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        this.checkForNewColor(selectedStates);
        Set<String> extraColors = this.extraColorMaps.keySet();
        if (!extraColors.isEmpty()) {
            items.add((IContributionItem)new Separator());
        }
        for (String actionID : extraColors) {
            Color color = this.extraColorMaps.get(actionID);
            String colorName = ((IAppearanceButtonDecorationWithMenu)CITextColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText((Object)color);
            UIChangeAppearanceAction action2 = new UIChangeAppearanceAction(workbenchPage, actionID, colorName, (Object)color, CITextColorConstantsAndMaps.APPEARANCE_DECORATION);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CITextColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage((Object)color);
            action2.setImageDescriptor(imageDescriptor);
            action2.setEnabled(enabled);
            if (enabled) {
                checked = this.isActionChecked(color, selectedStates);
            }
            action2.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action2));
        }
        items.add((IContributionItem)new Separator());
        Color dialogColor = CITextColorConstantsAndMaps.changeColorAction.getColor();
        if (!dialogColor.equalsColor(CITextColorConstantsAndMaps.INIT_COLOR)) {
            String colorName = ((IAppearanceButtonDecorationWithMenu)CITextColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryText((Object)dialogColor);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)CITextColorConstantsAndMaps.APPEARANCE_DECORATION).getMenuEntryImage((Object)dialogColor);
            action = new UIChangeAppearanceAction(workbenchPage, "com.arcway.cockpitplanagent.editor.actions.textcolor..custom", colorName, (Object)dialogColor, CITextColorConstantsAndMaps.APPEARANCE_DECORATION);
            action.setImageDescriptor(imageDescriptor);
            if (enabled) {
                checked = this.isActionChecked(dialogColor, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        CITextColorConstantsAndMaps.changeColorAction.setEnabled(enabled);
        CITextColorConstantsAndMaps.changeColorAction.setChecked(false);
        items.add((IContributionItem)new ActionContributionItem((IAction)CITextColorConstantsAndMaps.changeColorAction));
        return items;
    }

    private void checkForNewColor(ArrayList<Object> selectedStates) {
        this.extraColorMaps = new HashMap<String, Color>();
        for (Object state : selectedStates) {
            Color color;
            if (!(state instanceof Color) || !this.isNewColor(color = (Color)state)) continue;
            String actionID = "com.arcway.cockpitplanagent.editor.actions.textcolor." + color.toString();
            this.extraColorMaps.put(actionID, color);
        }
    }

    private boolean isActionChecked(Color color, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            Color selectedColor;
            if (state instanceof Color && (checked = color.equalsColor(selectedColor = (Color)state))) break;
        }
        return checked;
    }

    private boolean isNewColor(Color state) {
        boolean newState = true;
        Color dialogColor = CITextColorConstantsAndMaps.changeColorAction.getColor();
        if (dialogColor.equalsColor(state)) {
            return false;
        }
        for (Color color : CITextColorConstantsAndMaps.colorMaps.values()) {
            if (!color.equalsColor(state)) continue;
            newState = false;
            break;
        }
        return newState;
    }
}

