/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.bpmn.bpd.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.bpmn.bpd.actions.UIAbstractEventAction;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMGraphicalSupplementBPMNBPDEventTypeSymbolRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDEventRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDEventRW;
import com.arcway.planagent.planmodel.bpmn.bpd.check.BPMNBPDEventVariantTypeValidityMatrix;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class UIAbstractCreateEventTypeSymbolAction
extends UIAbstractEventAction {
    private static final ILogger logger = Logger.getLogger(UIAbstractCreateEventTypeSymbolAction.class);
    private final ImageDescriptor normalTypeIcon;
    private final ImageDescriptor invertedTypeIcon;

    public UIAbstractCreateEventTypeSymbolAction(ContextMenuContext context, String text, String toolTipText, String id, ImageDescriptor normalTypeIcon, ImageDescriptor invertedTypeIcon) {
        super(context, 8);
        if (logger.isTraceEnabled()) {
            logger.trace("UIAbstractCreateEventTypeSymbolAction(ContextMenuContext context = " + context + ") - start");
        }
        this.normalTypeIcon = normalTypeIcon;
        this.invertedTypeIcon = invertedTypeIcon;
        this.setText(text);
        this.setToolTipText(toolTipText);
        this.setId(id);
        this.setChecked(this.calculateChecked());
        if (normalTypeIcon != null) {
            this.setImageDescriptor(normalTypeIcon);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("UIAbstractCreateEventTypeSymbolAction(ContextMenuContext) - end");
        }
    }

    protected boolean calculateEnabled() {
        IPMPlanElementBPMNBPDEventRO selectedEvent = this.getSelectedEvent();
        if (selectedEvent != null && BPMNBPDEventVariantTypeValidityMatrix.isCombinationValid((IPMPlanElementBPMNBPDEventRW.EventVariant)selectedEvent.getEventVariant(), this.getResponsibleClass())) {
            this.updateImageDescriptor(selectedEvent.getEventVariant());
            return true;
        }
        this.updateImageDescriptor(IPMPlanElementBPMNBPDEventRW.EventVariant.Unspecified);
        return false;
    }

    protected boolean calculateChecked() {
        IPMPlanElementBPMNBPDEventRO selectedEvent = this.getSelectedEvent();
        if (selectedEvent == null) {
            return false;
        }
        IPMGraphicalSupplementBPMNBPDEventTypeSymbolRO supplement = selectedEvent.getEventTypeSymbolRO();
        if (supplement != null && supplement.getClass().equals(this.getResponsibleClass())) {
            return true;
        }
        return supplement == null && this.getResponsibleClass() == null;
    }

    protected abstract Class<? extends IPMGraphicalSupplementBPMNBPDEventTypeSymbolRO> getResponsibleClass();

    protected Command getCommand(List<PEPlanElement> items) {
        IPMPlanElementBPMNBPDEventRO event;
        assert (items != null) : "items is null";
        if (this.isChecked() && !items.isEmpty() && (event = this.getSelectedEvent(items)) instanceof IPMPlanElementBPMNBPDEventRW) {
            return this.getCreateEventTypeSymbolCommand((IPMPlanElementBPMNBPDEventRW)event);
        }
        return null;
    }

    protected abstract Command getCreateEventTypeSymbolCommand(IPMPlanElementBPMNBPDEventRW var1);

    protected boolean isVisibleIfDisabled() {
        return true;
    }

    protected boolean isVisibleInProjectionMode() {
        return false;
    }

    private void updateImageDescriptor(IPMPlanElementBPMNBPDEventRW.EventVariant variant) {
        switch (variant) {
            case IntermediateThrowing: 
            case End: {
                this.setImageDescriptor(this.invertedTypeIcon);
                break;
            }
            default: {
                this.setImageDescriptor(this.normalTypeIcon);
            }
        }
    }
}

