/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.planeditor.plugin;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentControllingInterfacePlugin;
import com.arcway.planagent.controllinginterface.planeditor.PlanEditorPaletteExtension;
import com.arcway.planagent.controllinginterface.planeditor.plugin.IContextMenuActionProvider;
import com.arcway.planagent.controllinginterface.planeditor.plugin.IContributor;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ITransferableTemplateProvider;
import com.arcway.planagent.controllinginterface.planeditor.plugin.TransferableTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class PlanEditorExtensionMgr {
    private static final ILogger LOGGER = Logger.getLogger(PlanEditorExtensionMgr.class);
    private static PlanEditorExtensionMgr singelton;
    private static final String EXTENSION_POINT_ID_VIEWS = "views";
    private static final String CONFIG_ELEMENT_NAME_VIEW_SET = "ViewSet";
    private static final String PALETTE_VIEW_ID_ATTRIBUTE = "PaletteViewId";
    private static final String OVERVIEW_ID_ATTRIBUTE = "OverViewId";
    private static final String EXTENSION_POINT_ID_CONTEXT_MENU_ACTION_PROVIDER = "contextmenuactionprovider";
    private static final String CONFIG_ELEMENT_NAME_CONTEXT_MENU_ACTION_PROVIDER = "ActionProvider";
    private static final String ATTR_CONTEXT_MENU_ACTION_PROVIDER_ID = "actionprovider";
    private static final String EXTENSION_POINT_ID_ACTION_BAR_CONTRIBUTIONS = "actionbarcontributions";
    private static final String CONFIG_ELEMENT_NAME_ACTION_BAR_CONTRIBUTION = "ActionBarContribution";
    private static final String ATTR_ACTION_BAR_CONTRIBUTOR = "contributor";
    private static final String EXTENSION_POINT_ID_TEMPLATE_PROVIDER = "transferabletemplateprovider";
    private static final String CONFIG_ELEMENT_NAME_TEMPLATE_PROVIDER = "TemplateProvider";
    private static final String ATTR_TEMPLATE_PROVIDER_ID = "templateprovider";
    private static final String EXTENSION_POINT_ID_PALETTE_EXTENSION = "paletteextension";
    private static final String CONFIG_ELEMENT_NAME_PALETTE_EXTENSION = "PaletteExtension";
    private static final String ATTR_PALETTE_EXTENSION_ID = "paletteextension";
    private static List<String> paletteViewIDs;
    private static List<String> overViewIDs;
    private static List<IContextMenuActionProvider> contextMenuActionProviders;
    private static List<IContributor> actionBarContributors;
    private static List<ITransferableTemplateProvider> templateProviders;
    private static Map<String, List<PlanEditorPaletteExtension>> paletteExtensions;

    private PlanEditorExtensionMgr() {
        singelton = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlanEditorExtensionMgr getDefault() {
        Class<PlanEditorExtensionMgr> clazz = PlanEditorExtensionMgr.class;
        synchronized (PlanEditorExtensionMgr.class) {
            if (singelton == null) {
                singelton = new PlanEditorExtensionMgr();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singelton;
        }
    }

    private String getPlugInID() {
        return PlanAgentControllingInterfacePlugin.getDefault().getPlugInID();
    }

    public List<String> getRegisteredPaletteViews() {
        if (paletteViewIDs == null) {
            this.readViewsExtensionPoint();
        }
        return paletteViewIDs;
    }

    public List<String> getRegisteredOverViews() {
        if (overViewIDs == null) {
            this.readViewsExtensionPoint();
        }
        return overViewIDs;
    }

    public List<PlanEditorPaletteExtension> getPaletteExtensions(String planTypeID) {
        List<PlanEditorPaletteExtension> extensions = this.getPaletteExtensions().get(planTypeID);
        if (extensions == null) {
            extensions = Collections.emptyList();
        }
        return extensions;
    }

    private void readViewsExtensionPoint() {
        IExtension[] extensions;
        paletteViewIDs = new ArrayList<String>();
        overViewIDs = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        assert (registry != null) : "registry must not be null";
        IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_VIEWS);
        assert (extensionPoint != null) : "extensionPoint must not be null";
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (CONFIG_ELEMENT_NAME_VIEW_SET.equals(currentConfigElement.getName())) {
                    String overViewID;
                    String paletteViewID = currentConfigElement.getAttribute(PALETTE_VIEW_ID_ATTRIBUTE);
                    if (paletteViewID != null) {
                        paletteViewIDs.add(paletteViewID);
                    }
                    if ((overViewID = currentConfigElement.getAttribute(OVERVIEW_ID_ATTRIBUTE)) != null) {
                        overViewIDs.add(overViewID);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public List<IContextMenuActionProvider> getContextMenuActionProviders() {
        if (contextMenuActionProviders == null) {
            IExtension[] extensions;
            contextMenuActionProviders = new ArrayList<IContextMenuActionProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_CONTEXT_MENU_ACTION_PROVIDER);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_CONTEXT_MENU_ACTION_PROVIDER.equals(currentConfigElement.getName())) {
                        try {
                            Object instance = currentConfigElement.createExecutableExtension(ATTR_CONTEXT_MENU_ACTION_PROVIDER_ID);
                            if (instance instanceof IContextMenuActionProvider) {
                                contextMenuActionProviders.add((IContextMenuActionProvider)instance);
                            } else {
                                LOGGER.error((Throwable)new Exception("Created instance of context menu action provider is not of type ContextMenuActionProvider."));
                            }
                        }
                        catch (CoreException e) {
                            LOGGER.error((Throwable)new Exception("Cannot instanciate context menu action provider."));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return contextMenuActionProviders;
    }

    private Map<String, List<PlanEditorPaletteExtension>> getPaletteExtensions() {
        if (paletteExtensions == null) {
            IExtension[] extensions;
            paletteExtensions = new HashMap<String, List<PlanEditorPaletteExtension>>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), "paletteextension");
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PALETTE_EXTENSION.equals(currentConfigElement.getName())) {
                        try {
                            Object instance = currentConfigElement.createExecutableExtension("paletteextension");
                            if (instance instanceof PlanEditorPaletteExtension) {
                                PlanEditorPaletteExtension paletteExtension = (PlanEditorPaletteExtension)instance;
                                String planTypeID = paletteExtension.getPlanTypeID();
                                List<PlanEditorPaletteExtension> listOfExtensionForPlanType = paletteExtensions.get(planTypeID);
                                if (listOfExtensionForPlanType == null) {
                                    listOfExtensionForPlanType = new ArrayList<PlanEditorPaletteExtension>();
                                    paletteExtensions.put(planTypeID, listOfExtensionForPlanType);
                                }
                                listOfExtensionForPlanType.add(paletteExtension);
                            } else {
                                LOGGER.error((Throwable)new Exception("Created instance of palette extension is not of type PlanEditorPaletteExtension."));
                            }
                        }
                        catch (CoreException e) {
                            LOGGER.error((Throwable)new Exception("Cannot instanciate palette extension."));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return paletteExtensions;
    }

    public List<IContributor> getActionbarContributionDescriptions() {
        if (actionBarContributors == null) {
            IExtension[] extensions;
            actionBarContributors = new ArrayList<IContributor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_ACTION_BAR_CONTRIBUTIONS);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_ACTION_BAR_CONTRIBUTION.equals(currentConfigElement.getName())) {
                        IContributor contributor = null;
                        try {
                            Object instance = currentConfigElement.createExecutableExtension(ATTR_ACTION_BAR_CONTRIBUTOR);
                            if (instance instanceof IContributor) {
                                contributor = (IContributor)instance;
                            } else {
                                LOGGER.error("Created instance of action bar contributor is not of type IContributor.");
                            }
                        }
                        catch (CoreException e) {
                            LOGGER.error("Cannot instanciate action bar contributor.", (Throwable)e);
                        }
                        if (contributor != null) {
                            actionBarContributors.add(contributor);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return actionBarContributors;
    }

    public Collection<TransferableTemplate> getTransferableTemplates(String planElementTypeID, String planElementName, String planElementUID) {
        ArrayList<TransferableTemplate> transferableTemplates = new ArrayList<TransferableTemplate>();
        for (ITransferableTemplateProvider templateProvider : this.getTransferableTemplateProviders()) {
            transferableTemplates.addAll(templateProvider.getTransferableTemplates(planElementTypeID, planElementName, planElementUID));
        }
        return transferableTemplates;
    }

    public List<ITransferableTemplateProvider> getTransferableTemplateProviders() {
        if (templateProviders == null) {
            IExtension[] extensions;
            templateProviders = new ArrayList<ITransferableTemplateProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_TEMPLATE_PROVIDER);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_TEMPLATE_PROVIDER.equals(currentConfigElement.getName())) {
                        try {
                            Object instance = currentConfigElement.createExecutableExtension(ATTR_TEMPLATE_PROVIDER_ID);
                            if (instance instanceof ITransferableTemplateProvider) {
                                templateProviders.add((ITransferableTemplateProvider)instance);
                            } else {
                                LOGGER.error((Throwable)new Exception("Created instance of template provider is not of type ITransferableTemplateProvider."));
                            }
                        }
                        catch (CoreException e) {
                            LOGGER.error((Throwable)new Exception("Cannot instanciate tempalte provider."));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return templateProviders;
    }
}

