/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.planagent.plugin;

import com.arcway.lib.java.locale.resourcebundles.ArcwayStandardResourceBundleLoader;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class PlanTypeDescription {
    private final ClassLoader classLoader;
    private final String planTypeID;
    private final String planTypeNameKey;
    private final String planTypeNameInPluralKey;
    private final URL iconURL;
    private final URL iconLargeURL;
    private final String fileExtension;
    private final Map<Locale, String> planTypeNameCache = new HashMap<Locale, String>();
    private final Map<Locale, String> planTypeNameInPluralCache = new HashMap<Locale, String>();

    public PlanTypeDescription(ClassLoader classLoader, String planTypeID, String planTypeNameKey, String planTypeNameInPluralKey, URL iconURL, URL iconLargeURL, String fileExtension) {
        assert (planTypeID != null && planTypeNameKey != null && planTypeNameInPluralKey != null && iconURL != null && iconLargeURL != null && fileExtension != null);
        this.classLoader = classLoader;
        this.planTypeID = planTypeID;
        this.planTypeNameKey = planTypeNameKey;
        this.planTypeNameInPluralKey = planTypeNameInPluralKey;
        this.iconURL = iconURL;
        this.iconLargeURL = iconLargeURL;
        this.fileExtension = fileExtension;
    }

    public String getPlanTypeID() {
        return this.planTypeID;
    }

    public String getPlanTypeName(Locale contentLocale) {
        String name = this.planTypeNameCache.get(contentLocale);
        if (name == null) {
            ResourceBundle resourceBundle = ArcwayStandardResourceBundleLoader.getBundle((String)"plugin", (Locale)contentLocale, (ClassLoader)this.classLoader);
            name = resourceBundle.getString(this.planTypeNameKey);
            this.planTypeNameCache.put(contentLocale, name);
        }
        return name;
    }

    public String getPlanTypeNameInPlural(Locale contentLocale) {
        String name = this.planTypeNameInPluralCache.get(contentLocale);
        if (name == null) {
            ResourceBundle resourceBundle = ArcwayStandardResourceBundleLoader.getBundle((String)"plugin", (Locale)contentLocale, (ClassLoader)this.classLoader);
            name = resourceBundle.getString(this.planTypeNameInPluralKey);
            this.planTypeNameInPluralCache.put(contentLocale, name);
        }
        return name;
    }

    public URL getIconURL() {
        return this.iconURL;
    }

    public URL getIconLargeURL() {
        return this.iconLargeURL;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }
}

