/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.planagent.plugin;

import com.arcway.lib.java.locale.resourcebundles.ArcwayStandardResourceBundleLoader;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class PlanElementTypeDescription {
    private final ClassLoader classLoader;
    private final String planElementTypeID;
    private final String planElementTypeNameKey;
    private final String planElementTypeNameInPluralKey;
    private final URL iconURL;
    private final Map<Locale, String> planElementTypeNameCache = new HashMap<Locale, String>();
    private final Map<Locale, String> planElementTypeNameInPluralCache = new HashMap<Locale, String>();
    private final int priority;

    public PlanElementTypeDescription(ClassLoader classLoader, String planElementTypeID, String planElementTypeNameKey, String planElementTypeNameInPluralKey, URL iconURL, int priority) {
        assert (planElementTypeID != null && planElementTypeNameKey != null && planElementTypeNameInPluralKey != null);
        this.classLoader = classLoader;
        this.planElementTypeID = planElementTypeID;
        this.planElementTypeNameKey = planElementTypeNameKey;
        this.planElementTypeNameInPluralKey = planElementTypeNameInPluralKey;
        this.iconURL = iconURL;
        this.priority = priority;
    }

    public String getPlanElementTypeID() {
        return this.planElementTypeID;
    }

    public String getPlanElementTypeName(Locale contentLocale) {
        String name = this.planElementTypeNameCache.get(contentLocale);
        if (name == null) {
            ResourceBundle resourceBundle = ArcwayStandardResourceBundleLoader.getBundle((String)"plugin", (Locale)contentLocale, (ClassLoader)this.classLoader);
            name = resourceBundle.getString(this.planElementTypeNameKey);
            this.planElementTypeNameCache.put(contentLocale, name);
        }
        return name;
    }

    public String getPlanElementTypeNameInPlural(Locale contentLocale) {
        String name = this.planElementTypeNameInPluralCache.get(contentLocale);
        if (name == null) {
            ResourceBundle resourceBundle = ArcwayStandardResourceBundleLoader.getBundle((String)"plugin", (Locale)contentLocale, (ClassLoader)this.classLoader);
            name = resourceBundle.getString(this.planElementTypeNameInPluralKey);
            this.planElementTypeNameInPluralCache.put(contentLocale, name);
        }
        return name;
    }

    public URL getIconURL() {
        return this.iconURL;
    }

    public int getPriority() {
        return this.priority;
    }
}

