/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.controllinginterface.lib.projections.AbstractProjection;

public class TextProjection
extends AbstractProjection {
    private final String text;
    private final Color textColor;
    private final double textWidth;
    private final TextStyle textStyle;
    private final double textHeight;
    private final Alignment alignment;
    private final double lineWidth;
    private final double lineHeight;
    private final int numberOfLines;

    public TextProjection(String text, Color textColor, double textWidth, TextStyle textStyle, double textHeight, Alignment alignment) {
        this.text = text;
        this.textWidth = textWidth;
        this.textColor = textColor;
        this.textStyle = textStyle;
        this.textHeight = textHeight;
        this.alignment = alignment;
        AbstractProjection.VirtualDevice virtualDevice = new AbstractProjection.VirtualDevice();
        int guessedNumberOfLines = virtualDevice.getNumberOfTextLines(this.getText(), this.getTextStyle(), this.getTextHeight(), this.getTextWidth());
        this.lineWidth = virtualDevice.getTextLength(this.getText(), this.getTextStyle(), this.getTextHeight(), guessedNumberOfLines);
        this.numberOfLines = virtualDevice.getNumberOfTextLines(this.getText(), this.getTextStyle(), this.getTextHeight(), this.lineWidth);
        this.lineHeight = virtualDevice.getTextLineHeight(this.getTextStyle(), this.getTextHeight());
        virtualDevice.dispose();
    }

    @Override
    public String getProjectionTypeID() {
        return "text";
    }

    public String getText() {
        return this.text;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public double getTextWidth() {
        return this.textWidth;
    }

    public double getTextHeight() {
        return this.textHeight;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    @Override
    protected Point getPositionInPixels(Rectangle area) {
        return area.upperLeft;
    }

    @Override
    protected void drawProjectionInPixels(Device device) {
        double textHeightSum = (double)this.numberOfLines * this.lineHeight;
        Rectangle rectangle = new Rectangle(0.0, 0.0, this.lineWidth, textHeightSum);
        device.text(rectangle, this.getAlignment(), this.getText(), this.getTextStyle(), this.getTextHeight(), this.getTextColor(), true);
    }
}

