/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;

public class TextLabelProjection
implements IProjection {
    private static final double CONVERSION_FACTOR_X = 0.35277777777777775;
    private static final double CONVERSION_FACTOR_Y = 0.35277777777777775;
    private static final double spacing = 0.7055555555555555;
    private static final double backgroundLineThickness = 0.35277777777777775;
    private final String text;
    private final double width = 26.105555555555554;
    private final double height = 3.5277777777777777;

    public TextLabelProjection(String text) {
        this.text = text;
    }

    @Override
    public String getProjectionTypeID() {
        return "textLabel";
    }

    public String getText() {
        return this.text;
    }

    protected Point getPositionInPixels(Rectangle area) {
        return new Point(area.lowerRight.x - 26.105555555555554, area.upperLeft.y);
    }

    @Override
    public void drawProjection(Device device) {
        Points rectangle = new Points();
        rectangle.add(Point.ORIGIN);
        rectangle.add(new Point(26.105555555555554, 0.0));
        rectangle.add(new Point(26.105555555555554, 3.5277777777777777));
        rectangle.add(new Point(0.0, 3.5277777777777777));
        FillStyle fillStyle = FillStyle.SOLID;
        FillColor fillColor = new FillColor(255, 255, 153);
        device.polygon(new Corners(rectangle, 0.0), fillColor, fillStyle);
        Alignment a = new Alignment(2, 16);
        TextStyle textStyle = new TextStyle("Arial");
        double textHeight = 3.5277777777777777;
        Color textColor = new Color(0, 0, 0);
        device.text(new Rectangle(Point.ORIGIN, new Point(26.105555555555554, 3.5277777777777777)), a, this.text, textStyle, textHeight, textColor, false);
    }

    @Override
    public Point getPosition(Rectangle area) {
        return new Point(area.lowerRight.x - 26.105555555555554 - 7.0, area.upperLeft.y + 6.0);
    }

    @Override
    public Rectangle getBoundary() {
        return new Rectangle(Math.floor(-0.8819444444444444), Math.floor(-0.8819444444444444), Math.ceil(26.987499999999997), Math.ceil(4.409722222222222));
    }
}

