/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverGetBounds;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;

public abstract class AbstractProjection
implements IProjection {
    private static final double FX = 0.35277777777777775;
    private static final double FY = 0.35277777777777775;
    private static final TransformationAffiliate TRANSFORMATION_PIXEL_TO_PROJECTION = TransformationAffiliate.newTransformationScaling((GeoVector)new GeoVector(0.35277777777777775, 0.35277777777777775));
    private static final TransformationAffiliate TRANSFORMATION_PROJECTION_TO_PIXEL = TRANSFORMATION_PIXEL_TO_PROJECTION.getInverse();

    @Override
    public final Point getPosition(Rectangle area) {
        Rectangle areaInPixels = area.transform((Transformation)TRANSFORMATION_PROJECTION_TO_PIXEL);
        Point positionInPixels = this.getPositionInPixels(areaInPixels);
        Point position = positionInPixels.transform((Transformation)TRANSFORMATION_PIXEL_TO_PROJECTION);
        return position;
    }

    @Override
    public final Rectangle getBoundary() {
        Rectangle boundaryInPixels = this.getBoundaryInPixels();
        Rectangle boundary = boundaryInPixels == null ? null : boundaryInPixels.transform((Transformation)TRANSFORMATION_PIXEL_TO_PROJECTION);
        return boundary;
    }

    protected Rectangle getBoundaryInPixels() {
        return this.getBoundaryByDrawingInPixels();
    }

    protected final Rectangle getBoundaryByDrawingInPixels() {
        DeviceDriverGetBounds deviceDriver = new DeviceDriverGetBounds(null);
        Device device = new Device((IDeviceDriver)deviceDriver, (Transformation)Transformation.NOP);
        this.drawProjectionForGetBoundsInPixels(device);
        Rectangle boundary = deviceDriver.getBounds();
        deviceDriver.dispose();
        return boundary;
    }

    protected void drawProjectionForGetBoundsInPixels(Device device) {
        this.drawProjectionInPixels(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void drawProjection(final Device device) {
        Device device2 = device;
        synchronized (device2) {
            device.subElement(null, null, null, (Transformation)TRANSFORMATION_PIXEL_TO_PROJECTION, (IDeviceRunnable)new IDeviceRunnable<RuntimeException>(){

                public void run() {
                    AbstractProjection.this.drawProjectionInPixels(device);
                }
            });
        }
    }

    protected abstract Point getPositionInPixels(Rectangle var1);

    protected abstract void drawProjectionInPixels(Device var1);

    protected class VirtualDevice
    extends Device {
        public VirtualDevice() {
            super((IDeviceDriver)new DeviceDriverGetBounds(), (Transformation)Transformation.NOP);
        }

        public void dispose() {
            ((DeviceDriverGetBounds)this.getDriver()).dispose();
        }
    }
}

