/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.stringtools;

import com.arcway.lib.java.Assert;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class StringCanonicalizer {
    private static StringCanonicalizer INSTANCE;
    private final WeakHashMap canonicalStrings = new WeakHashMap(50000, 0.5f);

    public static synchronized StringCanonicalizer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StringCanonicalizer();
        }
        return INSTANCE;
    }

    public static String getSystemWideCanonicalString(String string) {
        return StringCanonicalizer.getInstance().getCanonicalString(string);
    }

    public synchronized String getCanonicalString(String string) {
        assert (Assert.checkArgumentBeeingNotNull(string));
        String canonicalString = null;
        WeakReference wrCanonicalString = null;
        wrCanonicalString = (WeakReference)this.canonicalStrings.get(string);
        if (wrCanonicalString != null) {
            canonicalString = (String)wrCanonicalString.get();
        }
        if (canonicalString == null) {
            canonicalString = string;
            this.canonicalStrings.put(canonicalString, new WeakReference<String>(canonicalString));
        }
        return canonicalString;
    }
}

