/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.operating;

import com.arcway.lib.operating.AbstractProcessor;
import com.arcway.lib.operating.AbstractProcessorUnquantifiedWithoutCancel;
import com.arcway.lib.operating.EXProcessingException;
import com.arcway.lib.operating.IExceptionHandler;
import com.arcway.lib.operating.IProcessMonitor;
import com.arcway.lib.operating.IProcessStepLabel;
import com.arcway.lib.operating.IProcessingResult;
import com.arcway.lib.operating.IProcessorContext;
import com.arcway.lib.operating.IProcessorLabelProvider;

public class ExampleProcessor
extends AbstractProcessorUnquantifiedWithoutCancel {
    private final ExceptionHandler exceptionHandler;

    public ExampleProcessor(IExampleProcessorLabelProvider processLabelProvider, ExceptionHandler exceptionHandler) {
        super(processLabelProvider);
        this.exceptionHandler = exceptionHandler;
    }

    public IExampleResult process(boolean parameter, IProcessMonitor processMonitor) throws EXExampleProcessorProcessingException {
        IExampleResult result;
        ExampleProcessorContext processorContext = new ExampleProcessorContext(parameter);
        try {
            result = (IExampleResult)super.process(processorContext, processMonitor);
        }
        catch (EXProcessingException e) {
            throw (EXExampleProcessorProcessingException)e;
        }
        return result;
    }

    @Override
    protected Object excecute(IProcessorContext processorContext, AbstractProcessor.IMonitorUnquantified monitor) throws EXProcessingException {
        int i;
        IExampleProcessorLabelProvider labelProvider = (IExampleProcessorLabelProvider)this.getProcessorLabelProvider();
        ExampleProcessorContext exampleProcessorContext = (ExampleProcessorContext)processorContext;
        monitor.reportUnquantifiedProgress(labelProvider.getProcessStepLabelCheckParameter());
        if (exampleProcessorContext.isParameterSet()) {
            monitor.reportUnquantifiedProgress(labelProvider.getProcessStepLabelProcessVariantA());
            i = 0;
            while (i < 100) {
                ++i;
            }
        } else {
            monitor.reportUnquantifiedProgress(labelProvider.getProcessStepLabelProcessVariantB());
            i = 0;
            while (i < 1000) {
                if (i == 100) {
                    throw new EXExampleProcessorOverflow();
                }
                if (i == 700) {
                    throw new EXExampleProcessorFatalOverflow();
                }
                ++i;
            }
        }
        IExampleResult result = new IExampleResult(){};
        return result;
    }

    @Override
    protected boolean repair(IProcessorContext processorContext, EXProcessingException processingException) {
        EXExampleProcessorProcessingException exampleProcessorProcessingException = (EXExampleProcessorProcessingException)processingException;
        return this.exceptionHandler.repairExceptionCause(exampleProcessorProcessingException);
    }

    public static class EXExampleProcessorFatalOverflow
    extends EXExampleProcessorProcessingException {
    }

    public static class EXExampleProcessorOverflow
    extends EXExampleProcessorProcessingException {
    }

    public static abstract class EXExampleProcessorProcessingException
    extends EXProcessingException {
    }

    private static class ExampleProcessorContext
    implements IProcessorContext {
        private final boolean parameter;

        public ExampleProcessorContext(boolean parameter) {
            this.parameter = parameter;
        }

        public boolean isParameterSet() {
            return this.parameter;
        }
    }

    public static class ExceptionHandler
    implements IExceptionHandler {
        public static final ExceptionHandler DEFAULT = new ExceptionHandler();

        public boolean repairExceptionCause(EXExampleProcessorProcessingException processingException) {
            boolean exceptionCauseRepaired = false;
            if (processingException instanceof EXExampleProcessorOverflow) {
                exceptionCauseRepaired = true;
            } else {
                boolean cfr_ignored_0 = processingException instanceof EXExampleProcessorFatalOverflow;
            }
            return exceptionCauseRepaired;
        }
    }

    public static interface IExampleProcessorLabelProvider
    extends IProcessorLabelProvider {
        public IProcessStepLabel getProcessStepLabelCheckParameter();

        public IProcessStepLabel getProcessStepLabelProcessVariantA();

        public IProcessStepLabel getProcessStepLabelProcessVariantB();
    }

    public static interface IExampleResult
    extends IProcessingResult {
    }
}

