/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.network;

public class UserNameRetriever {
    public static String getUsername() throws UnableToRetrieveUsernameException {
        String userName;
        try {
            userName = System.getProperty("user.name");
            if (userName == null) {
                throw new UnableToRetrieveUsernameException("Unable to retrieve Username", new NullPointerException("System Property user.name is not set."));
            }
            if (userName.length() == 0) {
                throw new UnableToRetrieveUsernameException("Unable to retrieve Username", new IllegalArgumentException("System Property user.name is set, but empty."));
            }
        }
        catch (SecurityException se) {
            throw new UnableToRetrieveUsernameException("Unable to retrieve Username", se);
        }
        return userName;
    }

    public static class UnableToRetrieveUsernameException
    extends Exception {
        public UnableToRetrieveUsernameException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

