/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.logging;

import com.arcway.lib.logging.ILogger;
import java.util.Collection;
import java.util.Iterator;

public class LoggerBroadcaster
implements ILogger {
    private final Collection<ILogger> loggers;

    public LoggerBroadcaster(Collection<ILogger> loggers) {
        if (loggers == null) {
            throw new IllegalArgumentException();
        }
        this.loggers = loggers;
    }

    public void trace(String message) {
        for (ILogger logger : this.loggers) {
            logger.trace(message);
        }
    }

    public void debug(int debugCategory, String message) {
        for (ILogger logger : this.loggers) {
            logger.debug(debugCategory, message);
        }
    }

    public void debug(int debugCategory, String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.debug(debugCategory, message, t);
        }
    }

    public void debug(String message) {
        for (ILogger logger : this.loggers) {
            logger.debug(message);
        }
    }

    public void debug(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.debug(message, t);
        }
    }

    public void error(String message) {
        this.error(message, new Exception("This exception was generated automatically to get a stack trace."));
    }

    public void error(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.error(message, t);
        }
    }

    public void error(Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.error(t);
        }
    }

    public void fatal(String message) {
        this.fatal(message, new Exception("This exception was generated automatically to get a stack trace."));
    }

    public void fatal(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.fatal(message, t);
        }
    }

    public void fatal(Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.fatal(t);
        }
    }

    public void info(String message) {
        for (ILogger logger : this.loggers) {
            logger.info(message);
        }
    }

    public void info(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.info(message, t);
        }
    }

    public void warn(String message) {
        for (ILogger logger : this.loggers) {
            logger.warn(message);
        }
    }

    public void warn(String message, Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.warn(message, t);
        }
    }

    public void warn(Throwable t) {
        for (ILogger logger : this.loggers) {
            logger.warn(t);
        }
    }

    public boolean isInfoEnabled() {
        boolean enabled = false;
        Iterator<ILogger> i = this.loggers.iterator();
        while (!enabled && i.hasNext()) {
            ILogger logger = i.next();
            enabled |= logger.isInfoEnabled();
        }
        return enabled;
    }

    public boolean isDebugEnabled() {
        boolean enabled = false;
        Iterator<ILogger> i = this.loggers.iterator();
        while (!enabled && i.hasNext()) {
            ILogger logger = i.next();
            enabled |= logger.isDebugEnabled();
        }
        return enabled;
    }

    public boolean isDebugEnabled(int debugCategory) {
        boolean enabled = false;
        Iterator<ILogger> i = this.loggers.iterator();
        while (!enabled && i.hasNext()) {
            ILogger logger = i.next();
            enabled |= logger.isDebugEnabled(debugCategory);
        }
        return enabled;
    }

    public boolean isTraceEnabled() {
        boolean enabled = false;
        Iterator<ILogger> i = this.loggers.iterator();
        while (!enabled && i.hasNext()) {
            ILogger logger = i.next();
            enabled |= logger.isTraceEnabled();
        }
        return enabled;
    }
}

