/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.logging;

import com.arcway.lib.extensioning.AbstractExtensioningImplSingletonLoader;
import com.arcway.lib.extensioning.ExtensioningImplSingletonLoader;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.ILoggerManager;
import com.arcway.lib.logging.LoggerBroadcaster;
import java.util.ArrayList;
import java.util.Collection;

public class Logger {
    public static ILogger getLogger(final String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        ILoggerFactory loggerFactory = new ILoggerFactory(){

            @Override
            public ILogger createLogger(ILoggerManager loggerManager) {
                return loggerManager.getILogger(name);
            }
        };
        return Logger.createLogger(loggerFactory);
    }

    public static ILogger getLogger(final Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        ILoggerFactory loggerFactory = new ILoggerFactory(){

            @Override
            public ILogger createLogger(ILoggerManager loggerManager) {
                return loggerManager.getILogger(clazz);
            }
        };
        return Logger.createLogger(loggerFactory);
    }

    private static ILogger createLogger(ILoggerFactory loggerFactory) {
        Collection createdLoggers = Logger.createLoggers(loggerFactory);
        LoggerBroadcaster createdLogger = new LoggerBroadcaster(createdLoggers);
        return createdLogger;
    }

    private static Collection createLoggers(ILoggerFactory loggerFactory) {
        if (loggerFactory == null) {
            throw new IllegalArgumentException();
        }
        Collection loggerManagers = Logger.getRegisteredLoggerManagers();
        ArrayList<ILogger> createdLoggers = new ArrayList<ILogger>(loggerManagers.size());
        for (ILoggerManager loggerManager : loggerManagers) {
            ILogger createdLogger = loggerFactory.createLogger(loggerManager);
            createdLoggers.add(createdLogger);
        }
        return createdLoggers;
    }

    private static Collection getRegisteredLoggerManagers() {
        ExtensioningImplSingletonLoader.init();
        return AbstractExtensioningImplSingletonLoader.getLoader().getARCWAYLibExtensionManagerImplSingleton().getLoggerManagerExtensionPoint().getLoggerManagers();
    }

    private Logger() {
    }

    private static interface ILoggerFactory {
        public ILogger createLogger(ILoggerManager var1);
    }
}

