/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.tuples;

public class KeyTuple<T1, T2> {
    private final int cachedHashCode;
    private final T1 component1;
    private final T2 component2;

    public KeyTuple(T1 component1, T2 component2) {
        this.component1 = component1;
        this.component2 = component2;
        this.cachedHashCode = component1 != null && component2 != null ? component1.hashCode() + 31 * component2.hashCode() : (component1 == null && component2 != null ? component2.hashCode() : (component1 != null && component2 == null ? component1.hashCode() : 0));
    }

    public T1 getComponent1() {
        return this.component1;
    }

    public T2 getComponent2() {
        return this.component2;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (obj == this) {
            equals = true;
        } else if (obj instanceof KeyTuple) {
            KeyTuple spObj = (KeyTuple)obj;
            equals = (this.component1 == spObj.component1 || this.component1 != null && spObj.component1 != null && this.component1.equals(spObj.component1)) && (this.component2 == spObj.component2 || this.component2 != null && spObj.component2 != null && this.component2.equals(spObj.component2));
        } else {
            equals = false;
        }
        return equals;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        return String.valueOf(this.component1 == null ? "null" : this.component1.toString()) + "\n" + (this.component2 == null ? "null" : this.component2.toString());
    }

    public static <T> KeyTuple<T, Integer> createKeyTuple(T component1, int component2) {
        return new KeyTuple<T, Integer>(component1, component2);
    }
}

