/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.real;

import java.util.Arrays;

public class RealParser {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static double parseRealNumber(String stringRepresentation, char decimalSeparator, char thousandsSeparator) throws NumberFormatException {
        if (stringRepresentation == null || stringRepresentation.length() == 0) {
            throw new NumberFormatException("string representation is null");
        }
        double realNumber = 0.0;
        int sign = 1;
        boolean thousandsSeparatorFound = false;
        int thousandsSeparatorOffset = 0;
        boolean fractionalPartReached = false;
        long fractionalPart = 0L;
        int fractionalPartLength = 0;
        int absNumberStartIndex = 0;
        if (stringRepresentation.charAt(0) == '-') {
            sign = -1;
            absNumberStartIndex = 1;
        }
        int index = absNumberStartIndex;
        while (index < stringRepresentation.length()) {
            char currentChar = stringRepresentation.charAt(index);
            if (currentChar == decimalSeparator) {
                if (fractionalPartReached) {
                    throw new NumberFormatException("two or more decimal separators");
                }
                if (thousandsSeparatorFound && index % 4 != thousandsSeparatorOffset) {
                    throw new NumberFormatException("unregular occurrence of thousands separators (decimal separator too early)");
                }
                fractionalPartReached = true;
            } else if (currentChar == thousandsSeparator) {
                if (fractionalPartReached) {
                    throw new NumberFormatException("occurrence of thousands separator in fractional part");
                }
                if (!thousandsSeparatorFound) {
                    int indexInAbsNumber = index - (sign == -1 ? 1 : 0);
                    if (indexInAbsNumber == 0) {
                        throw new NumberFormatException("early occurrence of first thousands separator");
                    }
                    if (indexInAbsNumber > 3) {
                        throw new NumberFormatException("late occurrence of first thousands separator");
                    }
                    thousandsSeparatorFound = true;
                    thousandsSeparatorOffset = index;
                } else if (index % 4 != thousandsSeparatorOffset) {
                    throw new NumberFormatException("unregular occurrence of thousands separators (too early)");
                }
            } else {
                int digit = Arrays.binarySearch(digits, currentChar);
                if (digit >= 0) {
                    if (thousandsSeparatorFound && !fractionalPartReached && index % 4 == thousandsSeparatorOffset) {
                        throw new NumberFormatException("unregular occurrence of thousands separators (too late)");
                    }
                    if (!fractionalPartReached) {
                        realNumber = realNumber * 10.0 + (double)digit;
                    } else {
                        fractionalPart = fractionalPart * 10L + (long)digit;
                        ++fractionalPartLength;
                    }
                } else {
                    throw new NumberFormatException("invalid charater");
                }
            }
            ++index;
        }
        if (thousandsSeparatorFound && !fractionalPartReached && stringRepresentation.length() % 4 != thousandsSeparatorOffset) {
            throw new NumberFormatException("unregular occurrence of thousands separators (premature end of number)");
        }
        realNumber += (double)fractionalPart * Math.pow(10.0, -fractionalPartLength);
        return realNumber *= (double)sign;
    }
}

