/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class TreeProfilerNode {
    private final TreeProfilerNode parentNode;
    private final String packageName;
    private final String className;
    private final String methodName;
    private final int lineNumber;
    private int methodCount = 0;
    private final Map<String, TreeProfilerNode> subTrees = new HashMap<String, TreeProfilerNode>();

    TreeProfilerNode() {
        this.parentNode = null;
        this.packageName = "";
        this.className = "";
        this.methodName = "Calls";
        this.lineNumber = 0;
    }

    private TreeProfilerNode(TreeProfilerNode parentNode, StackTraceElement[] stackTrace, int depth) {
        this.parentNode = parentNode;
        StackTraceElement currentStackElement = stackTrace[depth];
        String fqClassName = currentStackElement.getClassName();
        int pos = fqClassName.lastIndexOf(46);
        if (pos >= 0) {
            this.packageName = fqClassName.substring(0, pos);
            this.className = fqClassName.substring(pos + 1);
        } else {
            this.packageName = "";
            this.className = fqClassName;
        }
        this.methodName = currentStackElement.getMethodName();
        this.lineNumber = currentStackElement.getLineNumber();
    }

    private TreeProfilerNode getRootProfilerNodeForSubtree(StackTraceElement[] stackTrace, int depth) {
        StackTraceElement nextStackElement = stackTrace[depth];
        String stackElementKey = this.calculateStackElementKey(nextStackElement);
        TreeProfilerNode nextSubTree = this.subTrees.get(stackElementKey);
        if (nextSubTree == null) {
            nextSubTree = new TreeProfilerNode(this, stackTrace, depth);
            this.subTrees.put(stackElementKey, nextSubTree);
        }
        return nextSubTree;
    }

    public void addCallStack(StackTraceElement[] stackTrace, int depth, int skip) {
        ++this.methodCount;
        int nextDepth = depth - 1;
        if (nextDepth > skip) {
            TreeProfilerNode nextSubTree = this.getRootProfilerNodeForSubtree(stackTrace, nextDepth);
            nextSubTree.addCallStack(stackTrace, nextDepth, skip);
        }
    }

    public void revokeCallStack(StackTraceElement[] stackTrace, int depth, int skip) {
        --this.methodCount;
        int nextDepth = depth - 1;
        if (nextDepth > skip) {
            TreeProfilerNode nextSubTree = this.getRootProfilerNodeForSubtree(stackTrace, nextDepth);
            nextSubTree.revokeCallStack(stackTrace, nextDepth, skip);
        }
    }

    private String calculateStackElementKey(StackTraceElement currentStackElement) {
        return String.valueOf(currentStackElement.getClassName()) + "." + currentStackElement.getMethodName() + "(" + currentStackElement.getLineNumber() + ")";
    }

    int getMethodCount() {
        return this.methodCount;
    }

    public String getLabel() {
        return String.valueOf(this.className) + "." + this.methodName + "(line " + this.lineNumber + "), " + this.methodCount + " samples, " + this.packageName;
    }

    private String getStackTraceLabel() {
        return "\tat " + this.packageName + "." + this.className + "." + this.methodName + "(" + this.className + ".java:" + this.lineNumber + ")";
    }

    public TreeProfilerNode[] getSubTrees() {
        ArrayList<TreeProfilerNode> subTreesAsList = new ArrayList<TreeProfilerNode>(this.subTrees.values());
        Collections.sort(subTreesAsList, new Comparator<TreeProfilerNode>(){

            @Override
            public int compare(TreeProfilerNode node1, TreeProfilerNode node2) {
                int sgn = node1.methodCount - node2.methodCount;
                if (sgn == 0 && (sgn = node1.packageName.compareTo(node2.packageName)) == 0 && (sgn = node1.methodName.compareTo(node2.methodName)) == 0) {
                    sgn = node1.lineNumber - node2.lineNumber;
                }
                return sgn;
            }
        });
        TreeProfilerNode[] subTreesAsArray = subTreesAsList.toArray(new TreeProfilerNode[subTreesAsList.size()]);
        return subTreesAsArray;
    }

    public void dump() {
        System.out.println("=====================================================================================");
        System.out.println();
        System.out.println("Profiler Dump");
        System.out.println("=============");
        System.out.println();
        this.dumpStackTraces();
    }

    private void dumpStackTraces() {
        TreeProfilerNode[] sortedSubTrees = this.getSubTrees();
        if (sortedSubTrees.length == 0) {
            System.out.println("-------------------------------------------------------------------------------------");
            System.out.println(String.valueOf(this.methodCount) + " calls:");
            this.dumpStackTrace();
        } else {
            TreeProfilerNode[] treeProfilerNodeArray = sortedSubTrees;
            int n = sortedSubTrees.length;
            int n2 = 0;
            while (n2 < n) {
                TreeProfilerNode subTree = treeProfilerNodeArray[n2];
                subTree.dumpStackTraces();
                ++n2;
            }
        }
    }

    private void dumpStackTrace() {
        if (this.parentNode != null) {
            System.out.println(this.getStackTraceLabel());
            this.parentNode.dumpStackTrace();
        }
    }
}

