/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.math;

import com.arcway.lib.java.math.Clip;

public class Sgn {
    private static final long MINUS_NULL = Long.MIN_VALUE;
    private static final long POSITIVE_INFINITY = 0x7FF0000000000000L;
    private static final long NEGATIVE_INFINITY = -4503599627370496L;
    private static final long NAN = 9221120237041090560L;

    public static int sgn(boolean minuent, boolean subtrahent) {
        int sgn = !minuent && subtrahent ? -1 : (minuent && !subtrahent ? 1 : 0);
        return sgn;
    }

    public static int sgn(int value) {
        int sgn = value < 0 ? -1 : (value > 0 ? 1 : 0);
        return sgn;
    }

    public static int sgn(long value) {
        int sgn = value < 0L ? -1 : (value > 0L ? 1 : 0);
        return sgn;
    }

    public static int sgn(double minuent, double subtrahent, long maxUlps) {
        int sgn;
        long longDiff;
        long minuentAsLong = Double.doubleToLongBits(minuent);
        long subtrahentAsLong = Double.doubleToLongBits(subtrahent);
        long minuentAs2ComplementLong = minuentAsLong >= 0L ? minuentAsLong : Long.MIN_VALUE - minuentAsLong;
        long subtrahentAs2ComplementLong = subtrahentAsLong >= 0L ? subtrahentAsLong : Long.MIN_VALUE - subtrahentAsLong;
        if (Sgn.sgn(minuentAs2ComplementLong) != Sgn.sgn(subtrahentAs2ComplementLong)) {
            minuentAs2ComplementLong = Clip.clipToInteger(minuentAs2ComplementLong);
            subtrahentAs2ComplementLong = Clip.clipToInteger(subtrahentAs2ComplementLong);
        }
        if ((longDiff = minuentAs2ComplementLong - subtrahentAs2ComplementLong) == 0L) {
            sgn = 0;
        } else {
            boolean minuentIsSpecial = minuentAsLong == -4503599627370496L || minuentAsLong == 0x7FF0000000000000L || minuentAsLong == 9221120237041090560L;
            boolean subtrahentIsSpecial = subtrahentAsLong == -4503599627370496L || subtrahentAsLong == 0x7FF0000000000000L || subtrahentAsLong == 9221120237041090560L;
            sgn = Math.abs(longDiff) <= maxUlps && !minuentIsSpecial && !subtrahentIsSpecial ? 0 : Sgn.sgn(longDiff);
        }
        return sgn;
    }

    public static <T extends Comparable<T>> int sgn(T minuent, T subtrahent) {
        int sgn = minuent != null && subtrahent != null ? Sgn.sgn(minuent.compareTo(subtrahent)) : (minuent != null && subtrahent == null ? 1 : (minuent == null && subtrahent != null ? -1 : 0));
        return sgn;
    }
}

