/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.maps;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.AbstractFundamentalSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.Entry_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.SortedKeySet_;
import com.arcway.lib.java.maps.ValueList_;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractMap_<K, V>
extends AbstractFundamentalSet_<IEntry_<? extends K, ? extends V>>
implements IMapRW_<K, V> {
    private final Map<MapKey, IEntry_<? extends K, ? extends V>> javaMap;
    private final IHasher_<? super K> keyHasher;

    protected AbstractMap_(Map<MapKey, IEntry_<? extends K, ? extends V>> javaMap, IHasher_<? super K> hasher) {
        assert (Assert.checkArgumentBeeingNotNull(javaMap));
        assert (Assert.checkArgumentBeeingNotNull(hasher));
        this.javaMap = javaMap;
        this.keyHasher = hasher;
    }

    @Override
    protected final Map<MapKey, IEntry_<? extends K, ? extends V>> getJavaMap() {
        return this.javaMap;
    }

    @Override
    public final IHasher_<? super K> getKeyHasher() {
        return this.keyHasher;
    }

    protected final MapKey createMapKey(IEntry_<? extends K, ? extends V> wrappedObject) {
        return new MapKey(wrappedObject.getKey());
    }

    protected final MapKey createMapKeyByKey(K wrappedObject) {
        return new MapKey(wrappedObject);
    }

    @Override
    public IEntry_<? extends K, ? extends V> replace(IEntry_<? extends K, ? extends V> object) {
        assert (Assert.checkArgumentBeeingNotNull(object));
        MapKey key = this.createMapKey(object);
        return this.getJavaMap().put(key, object);
    }

    @Override
    public boolean containsKey(K key) {
        assert (Assert.checkArgumentBeeingNotNull(key));
        MapKey mapKey = this.createMapKeyByKey(key);
        return this.getJavaMap().containsKey(mapKey);
    }

    @Override
    public V getByKey(K key) {
        IEntry_<K, V> entry = this.getEntryByKey(key);
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public IEntry_<? extends K, ? extends V> getEntryByKey(K key) {
        assert (Assert.checkArgumentBeeingNotNull(key));
        MapKey mapKey = this.createMapKeyByKey(key);
        return this.getJavaMap().get(mapKey);
    }

    @Override
    public ISet_<K> keySet() {
        return new SortedKeySet_(this);
    }

    @Override
    public ICollection_<V> values() {
        return new ValueList_(this);
    }

    @Override
    public boolean put(K key, V value) {
        return this.replace(key, value) != null;
    }

    @Override
    public void putAll(ICollection_<? extends IEntry_<? extends K, ? extends V>> entries) {
        assert (Assert.checkArgumentBeeingNotNull(entries));
        for (IEntry_ iEntry_ : entries) {
            this.replace(iEntry_);
        }
    }

    @Override
    public IEntry_<? extends K, ? extends V> removeAsEntry(K key) {
        assert (Assert.checkArgumentBeeingNotNull(key));
        MapKey mapKey = this.createMapKeyByKey(key);
        return this.getJavaMap().remove(mapKey);
    }

    @Override
    public V removeAsValue(K key) {
        IEntry_<K, V> oldEntry = this.removeAsEntry(key);
        if (oldEntry != null) {
            return oldEntry.getValue();
        }
        return null;
    }

    @Override
    public V replace(K key, V value) {
        assert (Assert.checkArgumentBeeingNotNull(key));
        assert (Assert.checkArgumentBeeingNotNull(value));
        MapKey mapKey = this.createMapKeyByKey(key);
        IEntry_ oldEntry = this.getJavaMap().put(mapKey, new Entry_<K, V>(key, value));
        if (oldEntry != null) {
            return oldEntry.getValue();
        }
        return null;
    }

    @Override
    public void removeAllByKeys(ICollection_<? extends K> keys) {
        assert (Assert.checkArgumentBeeingNotNull(keys));
        for (Object key : keys) {
            this.removeAsEntry(key);
        }
    }

    @Override
    public void retainAllByKeys(ISet_<K> keySet) {
        assert (Assert.checkArgumentBeeingNotNull(keySet));
        Iterator i = this.iterator();
        while (i.hasNext()) {
            IEntry_ currentEntry = (IEntry_)i.next();
            if (keySet.contains(currentEntry.getKey())) continue;
            i.remove();
        }
    }

    protected final class MapKey {
        final K wrappedObject;

        protected MapKey(K object) {
            assert (Assert.checkArgumentBeeingNotNull(object));
            this.wrappedObject = object;
        }

        public boolean equals(Object mapKeyToBeCompared) {
            assert (Assert.checkArgumentBeeingNotNull(mapKeyToBeCompared));
            assert (Assert.checkObjectArgumentToBeInstanceOf(mapKeyToBeCompared, MapKey.class));
            return AbstractMap_.this.getKeyHasher().isEqual(this.wrappedObject, ((MapKey)mapKeyToBeCompared).wrappedObject);
        }

        public int hashCode() {
            return AbstractMap_.this.getKeyHasher().getHashCode(this.wrappedObject);
        }
    }
}

