/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.locale.resourcebundles;

import com.arcway.lib.java.locale.LocaleHelper;
import com.arcway.lib.java.locale.resourcebundles.IGeneralResourceBundleLoader;
import com.arcway.lib.java.locale.resourcebundles.IResourceBundleLoaderPolicy;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class GeneralResourceBundleLoader {
    private static final Locale UNDEFINED_LOCALE = new Locale("");

    public static ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader classLoader, IResourceBundleLoaderPolicy policy) throws MissingResourceException {
        return policy.getBundle(bundleName, locale, classLoader, new IGeneralResourceBundleLoader(){

            @Override
            public ResourceBundle getBundle(String bundleName_, Locale locale_, ClassLoader classLoader_internal, boolean preferClientLocaleOverDefault, Locale fallbackLocale) throws MissingResourceException {
                return GeneralResourceBundleLoader.getBundle(bundleName_, locale_, classLoader_internal, preferClientLocaleOverDefault, fallbackLocale);
            }
        });
    }

    private static ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader classLoader, boolean preferClientLocaleOverDefault, Locale fallbackLocale) throws MissingResourceException {
        Locale foundLocale;
        ResourceBundle foundBundle;
        try {
            foundBundle = ResourceBundle.getBundle(bundleName, locale, classLoader);
        }
        catch (MissingResourceException mrE) {
            foundBundle = null;
        }
        Locale locale2 = foundLocale = foundBundle != null ? foundBundle.getLocale() : null;
        if (!preferClientLocaleOverDefault && foundLocale != null && LocaleHelper.getDistance(locale, foundLocale) == 3 && !foundLocale.equals(UNDEFINED_LOCALE)) {
            try {
                foundBundle = ResourceBundle.getBundle(bundleName, UNDEFINED_LOCALE, classLoader);
            }
            catch (MissingResourceException mrE) {
                foundBundle = null;
            }
        }
        if (foundBundle == null && fallbackLocale != null) {
            try {
                foundBundle = ResourceBundle.getBundle(bundleName, fallbackLocale, classLoader);
                foundLocale = foundBundle.getLocale();
                if (LocaleHelper.getDistance(fallbackLocale, foundLocale) == 3) {
                    foundBundle = null;
                }
            }
            catch (MissingResourceException mrE) {
                foundBundle = null;
            }
        }
        if (foundBundle == null) {
            throw new MissingResourceException("Couldn't find bundle for \"" + locale.toString() + "\"", classLoader.toString(), bundleName);
        }
        return foundBundle;
    }
}

