/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.locale.resourcebundles;

import com.arcway.lib.java.locale.resourcebundles.ArcwayStandardResourceBundleLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AbstractLocalisedMessageProvider {
    private final String bundleName;
    private ResourceBundle clientLocaleBundle;

    public AbstractLocalisedMessageProvider(String bundleName) {
        this.bundleName = bundleName;
        try {
            this.clientLocaleBundle = ArcwayStandardResourceBundleLoader.getBundle(bundleName, Locale.getDefault(), this.getClass());
        }
        catch (MissingResourceException mrE) {
            this.clientLocaleBundle = null;
        }
    }

    public final String getBundleName() {
        return this.bundleName;
    }

    public final String getString_(String key) {
        if (this.clientLocaleBundle != null) {
            try {
                return this.clientLocaleBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return String.valueOf('!') + key + '!';
    }

    public final String getString_(String key, Locale locale) {
        try {
            ResourceBundle bundle = ArcwayStandardResourceBundleLoader.getBundle(this.bundleName, locale, this.getClass());
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }
}

