/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.locale;

import com.arcway.lib.java.Assert;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PresentationContext {
    private final Locale locale;
    private final Date now;
    private final TimeZone timeZone;

    public static String convertISODateWithoutTimeToString(Date date, Locale contentLocale, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", contentLocale);
        dateFormat.setTimeZone(timeZone);
        String isoDate = dateFormat.format(date);
        return isoDate;
    }

    public static String convertISODateAndTimeWithoutSecondsToString(Date date, Locale contentLocale, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm", contentLocale);
        dateFormat.setTimeZone(timeZone);
        String isoDate = dateFormat.format(date);
        return isoDate;
    }

    public static String convertISODateAndTimeWithSecondsToString(Date date, Locale contentLocale, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss", contentLocale);
        dateFormat.setTimeZone(timeZone);
        String isoDate = dateFormat.format(date);
        return isoDate;
    }

    public static String convertDateWithoutTimeToString(Date date, Locale contentLocale, TimeZone timeZone) {
        DateFormat dateFormat = contentLocale.getLanguage().equals("de") ? new SimpleDateFormat("dd.MM.yyyy", contentLocale) : DateFormat.getDateInstance(2, contentLocale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    public static Date convertStringToDateWithoutTime(String date, Locale contentLocale, TimeZone timeZone) throws ParseException {
        DateFormat dateFormat = contentLocale.getLanguage().equals("de") ? new SimpleDateFormat("dd.MM.yyyy", contentLocale) : DateFormat.getDateInstance(2, contentLocale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.parse(date);
    }

    public static String convertDateAndTimeWithoutSecondsToString(Date date, Locale contentLocale, TimeZone timeZone) {
        DateFormat dateFormat = contentLocale.getLanguage().equals("de") ? new SimpleDateFormat("dd.MM.yyyy', 'H':'mm' Uhr'", contentLocale) : DateFormat.getDateTimeInstance(2, 3, contentLocale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    public static Date convertStringToDateAndTimeWithoutSeconds(String date, Locale contentLocale, TimeZone timeZone) throws ParseException {
        DateFormat dateFormat = contentLocale.getLanguage().equals("de") ? new SimpleDateFormat("dd.MM.yyyy', 'H':'mm' Uhr'", contentLocale) : DateFormat.getDateTimeInstance(2, 3, contentLocale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.parse(date);
    }

    public static String convertDateAndTimeWithSecondsToString(Date date, Locale contentLocale, TimeZone timeZone) {
        DateFormat dateFormat = contentLocale.getLanguage().equals("de") ? new SimpleDateFormat("dd.MM.yyyy', 'H':'mm':ss'", contentLocale) : DateFormat.getDateTimeInstance(2, 2, contentLocale);
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    public static synchronized PresentationContext getVirtualMachineUserLocaleForNow() {
        return new PresentationContext(Locale.getDefault(), new Date(), TimeZone.getDefault());
    }

    public static synchronized PresentationContext getVirtualMachineUserLocale(Date now) {
        return new PresentationContext(Locale.getDefault(), now, TimeZone.getDefault());
    }

    public PresentationContext(Locale locale, Date now, TimeZone timeZone) {
        Assert.checkArgumentBeeingNotNull(locale);
        Assert.checkArgumentBeeingNotNull(now);
        Assert.checkArgumentBeeingNotNull(timeZone);
        this.locale = locale;
        this.now = now;
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Date getNow() {
        return this.now;
    }

    public String convertISODateWithoutTimeToString(Date date, Locale contentLocale) {
        return PresentationContext.convertISODateWithoutTimeToString(date, contentLocale, this.timeZone);
    }

    public String convertISODateAndTimeWithoutSecondsToString(Date date, Locale contentLocale) {
        return PresentationContext.convertISODateAndTimeWithoutSecondsToString(date, contentLocale, this.timeZone);
    }

    public String convertISODateAndTimeWithSecondsToString(Date date, Locale contentLocale) {
        return PresentationContext.convertISODateAndTimeWithSecondsToString(date, contentLocale, this.timeZone);
    }

    public String convertDateWithoutTimeToString(Date date, Locale contentLocale) {
        return PresentationContext.convertDateWithoutTimeToString(date, contentLocale, this.timeZone);
    }

    public Date convertStringToDateWithoutTime(String date, Locale contentLocale) throws ParseException {
        return PresentationContext.convertStringToDateWithoutTime(date, contentLocale, this.timeZone);
    }

    public String convertDateAndTimeWithoutSecondsToString(Date date, Locale contentLocale) {
        return PresentationContext.convertDateAndTimeWithoutSecondsToString(date, contentLocale, this.timeZone);
    }

    public Date convertStringToDateAndTimeWithoutSeconds(String date, Locale contentLocale) throws ParseException {
        return PresentationContext.convertStringToDateAndTimeWithoutSeconds(date, contentLocale, this.timeZone);
    }

    public String convertDateAndTimeWithSecondsToString(Date date, Locale contentLocale) {
        return PresentationContext.convertDateAndTimeWithSecondsToString(date, contentLocale, this.timeZone);
    }

    public String getISODateWithoutTimeForNowAsString(Locale contentLocale) {
        return PresentationContext.convertISODateWithoutTimeToString(this.now, contentLocale, this.timeZone);
    }

    public String getISODateAndTimeWithoutSecondsForNowAsString(Locale contentLocale) {
        return PresentationContext.convertISODateAndTimeWithoutSecondsToString(this.now, contentLocale, this.timeZone);
    }

    public String getISODateAndTimeWithSecondsForNowAsString(Locale contentLocale) {
        return PresentationContext.convertISODateAndTimeWithSecondsToString(this.now, contentLocale, this.timeZone);
    }

    public String getLocaleDateWithoutTimeForNowAsString(Locale contentLocale) {
        return PresentationContext.convertDateWithoutTimeToString(this.now, contentLocale, this.timeZone);
    }

    public String getLocaleDateAndTimeWithoutSecondsForNowAsString(Locale contentLocale) {
        return PresentationContext.convertDateAndTimeWithoutSecondsToString(this.now, contentLocale, this.timeZone);
    }
}

