/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class PropertiesFile
extends File {
    private String fancyReadErrorMessage = null;
    private static final String EMPTY_MESSAGE = "";

    public PropertiesFile(File parent, String child) {
        super(parent, child);
    }

    public PropertiesFile(String pathname) {
        super(pathname);
    }

    public Properties readProperties() throws IOException {
        this.fancyReadErrorMessage = EMPTY_MESSAGE;
        Properties result = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(this);
                result.load(fis);
            }
            catch (FileNotFoundException e) {
                this.fancyReadErrorMessage = "readProperties() - Properties file " + this.getAbsolutePath() + " could not be found.";
                throw e;
            }
            catch (IOException e) {
                this.fancyReadErrorMessage = "readProperties() - Unable to read or close properties file " + this.getAbsolutePath() + " .";
                throw e;
            }
            catch (SecurityException e) {
                this.fancyReadErrorMessage = "readProperties() - Unable to read properties file " + this.getAbsolutePath() + " due to Security restriction: " + e.getLocalizedMessage();
                IOException ioex = new IOException(this.fancyReadErrorMessage);
                ioex.setStackTrace(e.getStackTrace());
                ioex.initCause(e);
                throw ioex;
            }
        }
        finally {
            block13: {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (this.fancyReadErrorMessage != EMPTY_MESSAGE) break block13;
                        this.fancyReadErrorMessage = "readProperties() - Unable to close properties file " + this.getAbsolutePath() + " .";
                        throw e;
                    }
                }
            }
        }
        return result;
    }

    public String getFancyErrorMessage() {
        return this.fancyReadErrorMessage;
    }
}

