/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMap_;

public class MapHasher<K, V>
implements IHasher_<IMap_<K, V>> {
    private final IHasher_<V> valueHasher;
    private K currentKey = null;

    public MapHasher(IHasher_<V> valueHasher) {
        this.valueHasher = valueHasher;
    }

    @Override
    public boolean isEqual(IMap_<K, V> object1, IMap_<K, V> object2) {
        boolean isEqual;
        if (object1 == object2) {
            isEqual = true;
        } else if (object1.size() != object2.size()) {
            isEqual = false;
        } else {
            isEqual = true;
            for (IEntry_ iEntry_ : object1) {
                V value2;
                Object key1 = iEntry_.getKey();
                Object value1 = iEntry_.getValue();
                if (value1 == (value2 = object2.getByKey(key1))) {
                    isEqual &= true;
                } else if (value2 == null) {
                    isEqual &= false;
                } else {
                    assert (this.currentKey == null);
                    this.currentKey = key1;
                    isEqual &= this.valueHasher.isEqual(value1, value2);
                    this.currentKey = null;
                }
                if (!isEqual) break;
            }
        }
        return isEqual;
    }

    @Override
    public int getHashCode(IMap_<K, V> object) {
        int hashCode = 0;
        IHasher_<K> keyHasher = object.getKeyHasher();
        for (IEntry_ iEntry_ : object) {
            Object key = iEntry_.getKey();
            Object value = iEntry_.getValue();
            hashCode ^= keyHasher.getHashCode(key);
            assert (this.currentKey == null);
            this.currentKey = key;
            hashCode ^= this.valueHasher.getHashCode(value);
            this.currentKey = null;
        }
        return hashCode;
    }

    public K getCurrentKey() {
        return this.currentKey;
    }
}

