/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IListIterator_;
import com.arcway.lib.java.collections.ISortedSetRW_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.java.collections.JSet_;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;

public final class JSortedSet_<T>
extends JSet_<T>
implements List<T> {
    public JSortedSet_(ISortedSet_<T> sortedSet) {
        super(sortedSet);
    }

    private ISortedSet_<T> getSortedSet() {
        return (ISortedSet_)this.getSet();
    }

    private ISortedSetRW_<T> getSortedSetRW() {
        return (ISortedSetRW_)this.getSetRW();
    }

    @Override
    public void add(int index, T element) {
        Assert.unsupportedOperation();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        Assert.unsupportedOperation();
        return false;
    }

    @Override
    public T get(int index) {
        return this.getSortedSet().get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getSortedSet().getIndexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new JListIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new JListIterator(index);
    }

    @Override
    public T remove(int index) {
        return this.getSortedSetRW().remove(this.get(index));
    }

    @Override
    public T set(int index, T element) {
        Assert.unsupportedOperation();
        return null;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        Assert.unsupportedOperation();
        return null;
    }

    @Override
    public Spliterator<T> spliterator() {
        return super.spliterator();
    }

    private final class JListIterator
    implements ListIterator<T> {
        private final IListIterator_<T> iListIterator;
        private int direction;
        private T lastReturned;

        public JListIterator() {
            this.iListIterator = JSortedSet_.this.getSortedSet().iterator();
            this.direction = 1;
            this.lastReturned = null;
        }

        public JListIterator(int currentIndex) {
            this.iListIterator = JSortedSet_.this.getSortedSet().iterator();
            assert (Assert.checkArgument(currentIndex >= 0));
            assert (Assert.checkArgument(currentIndex <= JSortedSet_.this.size()));
            int n = currentIndex;
            while (n > 0) {
                this.iListIterator.next();
                --n;
            }
            this.direction = 1;
            this.lastReturned = null;
        }

        @Override
        public int nextIndex() {
            if (this.direction == -1) {
                return this.iListIterator.index();
            }
            return this.iListIterator.index() + 1;
        }

        @Override
        public int previousIndex() {
            if (this.direction == 1) {
                return this.iListIterator.index();
            }
            return this.iListIterator.index() - 1;
        }

        @Override
        public boolean hasNext() {
            if (this.direction == -1) {
                return true;
            }
            return this.iListIterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            if (this.direction == 1) {
                return true;
            }
            return this.iListIterator.hasPrev();
        }

        @Override
        public T next() {
            if (this.direction == -1) {
                if (this.lastReturned != null) {
                    this.direction = 1;
                    return this.lastReturned;
                }
                throw new NoSuchElementException();
            }
            this.lastReturned = this.iListIterator.next();
            return this.lastReturned;
        }

        @Override
        public T previous() {
            if (this.direction == 1) {
                if (this.lastReturned != null) {
                    this.direction = -1;
                    return this.lastReturned;
                }
                throw new NoSuchElementException();
            }
            this.lastReturned = this.iListIterator.prev();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            Assert.unsupportedOperation();
        }

        @Override
        public void add(Object arg0) {
            Assert.unsupportedOperation();
        }

        @Override
        public void set(Object arg0) {
            Assert.unsupportedOperation();
        }
    }
}

