/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class JSet_<T>
implements Set<T> {
    private final ISet_<T> set;

    public JSet_(ISet_<T> set) {
        this.set = set;
    }

    protected ISet_<T> getSet() {
        return this.set;
    }

    protected ISetRW_<T> getSetRW() {
        if (!(this.set instanceof ISetRW_)) {
            Assert.unsupportedOperation();
        }
        return (ISetRW_)this.set;
    }

    @Override
    public boolean add(T o) {
        return this.getSetRW().replace(o) == null;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T element : c) {
            modified |= this.add(element);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.getSetRW().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.getSet().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean containsAll = true;
        for (Object o : c) {
            if (!(containsAll &= this.getSet().contains(o))) break;
        }
        return containsAll;
    }

    @Override
    public boolean isEmpty() {
        return this.getSet().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new JIterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.getSetRW().remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator i = this.getSetRW().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (c.contains(o)) continue;
            i.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public int size() {
        return this.getSet().size();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.getSet().size()];
        int idx = 0;
        for (Object current : this.getSet()) {
            array[idx++] = current;
        }
        return array;
    }

    @Override
    public <X> X[] toArray(X[] a) {
        Object[] array = a;
        int size = this.getSet().size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        Iterator<T> it = this.iterator();
        X[] ar = array;
        int i = 0;
        while (i < size) {
            ar[i] = it.next();
            ++i;
        }
        if (array.length > size) {
            i = size;
            while (i < array.length) {
                array[i] = null;
                ++i;
            }
        }
        return array;
    }

    private final class JIterator
    implements Iterator<T> {
        private final IIterator_<T> iIterator;
        private final boolean isIIteratorRW;

        protected JIterator() {
            ISet_ iSet = JSet_.this.getSet();
            if (iSet instanceof ISetRW_) {
                ISetRW_ iSetRW = (ISetRW_)iSet;
                this.iIterator = iSetRW.iterator();
                this.isIIteratorRW = true;
            } else {
                this.iIterator = iSet.iterator();
                this.isIIteratorRW = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.iIterator.hasNext();
        }

        @Override
        public T next() {
            return this.iIterator.next();
        }

        @Override
        public void remove() {
            if (this.isIIteratorRW) {
                ((IIteratorRW_)this.iIterator).remove();
            } else {
                Assert.unsupportedOperation();
            }
        }
    }
}

