/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CollectionUtils {
    private static final ILogger logger = Logger.getLogger(CollectionUtils.class);

    public static <T> Collection<T> getTypedCollection(Collection<?> collection, Class<T> type) {
        ArrayList checkedCollection = new ArrayList(collection.size());
        CollectionUtils.typeCollection(collection, checkedCollection, type);
        return checkedCollection;
    }

    public static <T> Set<T> getTypedSet(Set<?> set, Class<T> type) {
        HashSet checkedSet = new HashSet(set.size());
        CollectionUtils.typeCollection(set, checkedSet, type);
        return checkedSet;
    }

    public static <T> List<T> getTypedList(List<?> list, Class<T> type) {
        ArrayList checkedList = new ArrayList(list.size());
        CollectionUtils.typeCollection(list, checkedList, type);
        return checkedList;
    }

    private static <T> void typeCollection(Collection<?> source, Collection<T> target, Class<T> type) {
        for (Object element : source) {
            if (type.isAssignableFrom(element.getClass())) {
                target.add(type.cast(element));
                continue;
            }
            logger.warn("The collection to check contained an inappropriate element (found type: " + element.getClass().getName() + " / required type: " + type.getName() + ").");
        }
    }

    public static <T> Iterable<T> getMultiCollectionIterable(final Collection<? extends T> ... collections) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new MultiCollectionIterator(collections);
            }
        };
    }

    private static class MultiCollectionIterator<T>
    implements Iterator<T> {
        private final Collection<? extends T>[] collections;
        private int collectionIndex;
        private Iterator<? extends T> currentCollectionIterator;

        public MultiCollectionIterator(Collection<? extends T> ... collections) {
            this.collections = collections;
            if (collections.length > 0) {
                this.collectionIndex = 0;
                this.currentCollectionIterator = collections[0].iterator();
            } else {
                this.collectionIndex = 1;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.collectionIndex != -1) {
                if (this.currentCollectionIterator.hasNext()) {
                    return true;
                }
                int remainingCollectionIndex = this.collectionIndex + 1;
                while (remainingCollectionIndex < this.collections.length) {
                    if (this.collections[remainingCollectionIndex].size() > 0) {
                        return true;
                    }
                    ++remainingCollectionIndex;
                }
            }
            return false;
        }

        @Override
        public T next() {
            while (!this.currentCollectionIterator.hasNext() && this.collectionIndex < this.collections.length) {
                ++this.collectionIndex;
                if (this.collectionIndex >= this.collections.length) continue;
                this.currentCollectionIterator = this.collections[this.collectionIndex].iterator();
            }
            if (this.collectionIndex < this.collections.length) {
                return this.currentCollectionIterator.next();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

