/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IListIteratorRW_;
import com.arcway.lib.java.collections.IListRW_;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractList_<T>
implements IListRW_<T> {
    private final List<T> javaList;

    protected AbstractList_(List<T> javaList) {
        assert (Assert.checkArgumentBeeingNotNull(javaList));
        this.javaList = javaList;
    }

    private final List<T> getJavaList() {
        return this.javaList;
    }

    @Override
    public int size() {
        return this.getJavaList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getJavaList().isEmpty();
    }

    @Override
    public Collection<T> asJavaCollection() {
        return this.getJavaList();
    }

    @Override
    public void add(T element) {
        assert (Assert.checkArgumentBeeingNotNull(element));
        this.getJavaList().add(element);
    }

    @Override
    public void addAll(ICollection_<? extends T> elementsToAdd) {
        assert (Assert.checkArgumentBeeingNotNull(elementsToAdd));
        this.getJavaList().addAll(elementsToAdd.asJavaCollection());
    }

    @Override
    public void addAll(Collection<? extends T> elementsToAdd) {
        assert (Assert.checkArgumentBeeingNotNull(elementsToAdd));
        this.getJavaList().addAll(elementsToAdd);
    }

    @Override
    public void clear() {
        this.getJavaList().clear();
    }

    @Override
    public IListIteratorRW_<T> iterator() {
        return new It_();
    }

    @Override
    public T get(int index) {
        assert (Assert.checkArgument(index >= 0));
        assert (Assert.checkArgument(index < this.size()));
        return this.getJavaList().get(index);
    }

    @Override
    public List<T> asJavaList() {
        return this.getJavaList();
    }

    @Override
    public void add(T object, int index) {
        assert (Assert.checkArgumentBeeingNotNull(object));
        assert (Assert.checkArgument(index >= 0));
        assert (Assert.checkArgument(index <= this.size()));
        this.getJavaList().add(index, object);
    }

    @Override
    public void set(T object, int index) {
        assert (Assert.checkArgumentBeeingNotNull(object));
        assert (Assert.checkArgument(index >= 0));
        assert (Assert.checkArgument(index < this.size()));
        this.getJavaList().set(index, object);
    }

    @Override
    public void remove(int index) {
        assert (Assert.checkArgument(index >= 0));
        assert (Assert.checkArgument(index < this.size()));
        this.getJavaList().remove(index);
    }

    private final class It_
    implements IListIteratorRW_<T> {
        private final ListIterator<T> javaListIterator;
        private int direction;

        protected It_() {
            this.javaListIterator = AbstractList_.this.getJavaList().listIterator();
            this.direction = 1;
        }

        @Override
        public int index() {
            if (this.direction == 1) {
                return this.javaListIterator.previousIndex();
            }
            if (this.direction == -1) {
                return this.javaListIterator.nextIndex();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean hasNext() {
            if (this.direction == -1 && this.javaListIterator.hasNext()) {
                this.direction = 1;
                this.javaListIterator.next();
            }
            return this.javaListIterator.hasNext();
        }

        @Override
        public T next() {
            if (this.javaListIterator.hasNext()) {
                Object firstNext = this.javaListIterator.next();
                if (this.direction == -1) {
                    this.direction = 1;
                    if (this.javaListIterator.hasNext()) {
                        Object secondNext = this.javaListIterator.next();
                        return secondNext;
                    }
                } else {
                    if (this.direction == 0) {
                        this.direction = 1;
                        return firstNext;
                    }
                    return firstNext;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrev() {
            if (this.direction == 1 && this.javaListIterator.hasPrevious()) {
                this.direction = -1;
                this.javaListIterator.previous();
            }
            return this.javaListIterator.hasPrevious();
        }

        @Override
        public T prev() {
            if (this.javaListIterator.hasPrevious()) {
                Object firstPrevious = this.javaListIterator.previous();
                if (this.direction == 1) {
                    this.direction = -1;
                    if (this.javaListIterator.hasPrevious()) {
                        Object secondPrevious = this.javaListIterator.previous();
                        return secondPrevious;
                    }
                } else {
                    if (this.direction == 0) {
                        this.direction = -1;
                        return firstPrevious;
                    }
                    return firstPrevious;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.direction == 0) {
                throw new IllegalStateException();
            }
            this.direction = 0;
            this.javaListIterator.remove();
        }

        @Override
        public void insertAfter(T element) {
            if (this.direction == 1) {
                this.javaListIterator.add(element);
            } else if (this.direction == -1) {
                if (this.javaListIterator.hasNext()) {
                    this.direction = 1;
                    this.javaListIterator.next();
                    this.javaListIterator.add(element);
                }
            } else {
                throw new IllegalStateException();
            }
            this.javaListIterator.previous();
        }

        @Override
        public void insertBefore(T element) {
            if (this.direction == -1) {
                this.javaListIterator.add(element);
            } else if (this.direction == 1) {
                if (this.javaListIterator.hasPrevious()) {
                    this.direction = -1;
                    this.javaListIterator.previous();
                    this.javaListIterator.add(element);
                }
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public void set(T element) {
            if (this.direction == 0) {
                throw new IllegalStateException();
            }
            this.javaListIterator.set(element);
        }
    }
}

