/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.collections.JSet_;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFundamentalSet_<T>
implements ISetRW_<T> {
    protected AbstractFundamentalSet_() {
    }

    protected abstract Map<? extends Object, T> getJavaMap();

    protected abstract Object createMapKey(T var1);

    @Override
    public Collection<T> asJavaCollection() {
        return this.asJavaSet();
    }

    @Override
    public boolean isEmpty() {
        return this.getJavaMap().isEmpty();
    }

    @Override
    public int size() {
        return this.getJavaMap().size();
    }

    @Override
    public void add(T element) {
        this.replace(element);
    }

    @Override
    public void addAll(ICollection_<? extends T> elementsToAdd) {
        assert (Assert.checkArgumentBeeingNotNull(elementsToAdd));
        for (Object currentElement : elementsToAdd) {
            this.add(currentElement);
        }
    }

    @Override
    public void addAll(Collection<? extends T> elementsToAdd) {
        assert (Assert.checkArgumentBeeingNotNull(elementsToAdd));
        for (T currentElement : elementsToAdd) {
            this.add(currentElement);
        }
    }

    @Override
    public void clear() {
        this.getJavaMap().clear();
    }

    @Override
    public boolean contains(T object) {
        assert (Assert.checkArgumentBeeingNotNull(object));
        Object key = this.createMapKey(object);
        return this.getJavaMap().containsKey(key);
    }

    @Override
    public boolean containsAll(ICollection_<? extends T> objects) {
        assert (Assert.checkArgumentBeeingNotNull(objects));
        for (Object currentElement : objects) {
            if (this.contains(currentElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(T object) {
        assert (Assert.checkArgumentBeeingNotNull(object));
        Object key = this.createMapKey(object);
        return this.getJavaMap().get(key);
    }

    @Override
    public Set<T> asJavaSet() {
        return new JSet_(this);
    }

    @Override
    public T remove(T object) {
        assert (Assert.checkArgumentBeeingNotNull(object));
        Object key = this.createMapKey(object);
        return this.getJavaMap().remove(key);
    }

    @Override
    public void removeAll(ICollection_<? extends T> objectsToRemove) {
        assert (Assert.checkArgumentBeeingNotNull(objectsToRemove));
        for (Object currentElement : objectsToRemove) {
            this.remove(currentElement);
        }
    }

    @Override
    public void retainAll(ISet_<T> objectsToRetain) {
        assert (Assert.checkArgumentBeeingNotNull(objectsToRetain));
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object currentElement = i.next();
            if (objectsToRetain.contains(currentElement)) continue;
            i.remove();
        }
    }
}

