/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collectionmaps;

import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SetMapWithFixReturnSets<K, V>
implements ISetMapWithFixReturnSetsRO<K, V> {
    private final Set<V> unmodifiableEmptyValueSet = Collections.emptySet();
    private final HashMap<K, RwRoDouble<V>> map;
    private Set<K> unmodifiableKeySet;

    public SetMapWithFixReturnSets() {
        this(16);
    }

    public SetMapWithFixReturnSets(int capacity) {
        this.map = new HashMap(capacity, 0.5f);
        this.unmodifiableKeySet = null;
    }

    public boolean add(K key, V value) {
        boolean changed;
        RwRoDouble<V> rwRoDouble = this.map.get(key);
        if (rwRoDouble == null) {
            rwRoDouble = this.addKeyMapping(key);
        }
        if (rwRoDouble.rwSet == null) {
            rwRoDouble.rwSet = this.createNewValueSet(1);
            rwRoDouble.rwSet.add(value);
            changed = true;
        } else if (rwRoDouble.unmodifiableSet == null) {
            changed = rwRoDouble.rwSet.add(value);
        } else if (rwRoDouble.rwSet.contains(value)) {
            changed = false;
        } else {
            HashSet oldRwSet = rwRoDouble.rwSet;
            rwRoDouble.rwSet = this.createNewValueSet(oldRwSet.size() + 1);
            rwRoDouble.rwSet.addAll(oldRwSet);
            rwRoDouble.rwSet.add(value);
            rwRoDouble.unmodifiableSet = null;
            changed = true;
        }
        return changed;
    }

    public boolean addAll(K key, Collection<? extends V> values) {
        boolean changed;
        if (values.isEmpty()) {
            changed = false;
        } else {
            RwRoDouble<V> rwRoDouble = this.map.get(key);
            if (rwRoDouble == null) {
                rwRoDouble = this.addKeyMapping(key);
            }
            if (rwRoDouble.rwSet == null) {
                rwRoDouble.rwSet = this.createNewValueSet(1);
                rwRoDouble.rwSet.addAll(values);
                changed = true;
            } else if (rwRoDouble.unmodifiableSet == null) {
                changed = rwRoDouble.rwSet.addAll(values);
            } else {
                HashSet<V> newSet = this.createNewValueSet(rwRoDouble.rwSet.size() + values.size());
                newSet.addAll(rwRoDouble.rwSet);
                changed = newSet.addAll(values);
                if (changed) {
                    rwRoDouble.rwSet = newSet;
                    rwRoDouble.unmodifiableSet = null;
                }
            }
        }
        return changed;
    }

    public boolean remove(K key, V valueToBeRemoved) {
        boolean changed;
        RwRoDouble<V> rwRoDouble = this.map.get(key);
        if (rwRoDouble == null) {
            changed = false;
        } else {
            if (rwRoDouble.unmodifiableSet == null) {
                changed = rwRoDouble.rwSet.remove(valueToBeRemoved);
            } else if (rwRoDouble.rwSet.contains(valueToBeRemoved)) {
                HashSet oldRwSet = rwRoDouble.rwSet;
                rwRoDouble.rwSet = this.createNewValueSet(oldRwSet.size());
                rwRoDouble.rwSet.addAll(oldRwSet);
                rwRoDouble.rwSet.remove(valueToBeRemoved);
                rwRoDouble.unmodifiableSet = null;
                changed = true;
            } else {
                changed = false;
            }
            if (rwRoDouble.rwSet.isEmpty()) {
                assert (changed);
                this.removeKeyMapping(key);
            }
        }
        return changed;
    }

    public boolean removeAll(K key, Collection<? extends V> valuesToBeRemoved) {
        boolean changed;
        RwRoDouble<V> rwRoDouble = this.map.get(key);
        if (rwRoDouble == null || valuesToBeRemoved.isEmpty()) {
            changed = false;
        } else {
            if (rwRoDouble.unmodifiableSet == null) {
                changed = rwRoDouble.rwSet.removeAll(valuesToBeRemoved);
            } else {
                HashSet<V> newSet = this.createNewValueSet(rwRoDouble.rwSet.size());
                newSet.addAll(rwRoDouble.rwSet);
                changed = newSet.removeAll(valuesToBeRemoved);
                if (changed) {
                    rwRoDouble.rwSet = newSet;
                    rwRoDouble.unmodifiableSet = null;
                }
            }
            if (rwRoDouble.rwSet.isEmpty()) {
                assert (changed);
                this.removeKeyMapping(key);
            }
        }
        return changed;
    }

    public Set<V> remove(Object key) {
        RwRoDouble<V> previousRwRoDouble = this.removeKeyMapping(key);
        if (previousRwRoDouble != null) {
            return previousRwRoDouble.unmodifiableSet;
        }
        return this.unmodifiableEmptyValueSet;
    }

    @Override
    public Set<V> get(K key) {
        RwRoDouble<V> rwRoDouble = this.map.get(key);
        if (rwRoDouble != null) {
            if (rwRoDouble.unmodifiableSet == null) {
                rwRoDouble.unmodifiableSet = Collections.unmodifiableSet(rwRoDouble.rwSet);
            }
            return rwRoDouble.unmodifiableSet;
        }
        return this.unmodifiableEmptyValueSet;
    }

    public void clear() {
        if (!this.map.isEmpty()) {
            this.unmodifiableKeySet = null;
        }
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty(K key) {
        boolean isEmpty;
        RwRoDouble<V> rwRoDouble = this.map.get(key);
        if (rwRoDouble == null) {
            isEmpty = true;
        } else {
            isEmpty = rwRoDouble.rwSet.isEmpty();
            assert (!isEmpty);
        }
        return isEmpty;
    }

    @Override
    public boolean contains(K key, V value) {
        RwRoDouble<V> rwRoDouble = this.map.get(key);
        boolean contains = rwRoDouble == null ? false : rwRoDouble.rwSet.contains(value);
        return contains;
    }

    @Override
    public boolean containsAll(K key, Collection<? extends V> values) {
        RwRoDouble<V> rwRoDouble = this.map.get(key);
        boolean contains = rwRoDouble == null ? values.isEmpty() : rwRoDouble.rwSet.containsAll(values);
        return contains;
    }

    @Override
    public Set<K> keySet() {
        if (this.unmodifiableKeySet == null) {
            this.unmodifiableKeySet = Collections.unmodifiableSet(new HashSet<K>(this.map.keySet()));
        }
        return this.unmodifiableKeySet;
    }

    private RwRoDouble<V> removeKeyMapping(Object key) {
        RwRoDouble<V> oldMapping = this.map.remove(key);
        if (oldMapping != null) {
            this.unmodifiableKeySet = null;
        }
        return oldMapping;
    }

    private RwRoDouble<V> addKeyMapping(K key) {
        RwRoDouble rwRoDouble = new RwRoDouble();
        RwRoDouble oldMapping = this.map.put(key, rwRoDouble);
        assert (oldMapping == null);
        this.unmodifiableKeySet = null;
        return rwRoDouble;
    }

    private HashSet<V> createNewValueSet(int estimatedElementNumber) {
        int valueSetCapacity = estimatedElementNumber < 8 ? 16 : estimatedElementNumber * 2;
        return new HashSet(valueSetCapacity);
    }

    private static class RwRoDouble<V> {
        public HashSet<V> rwSet;
        public Set<V> unmodifiableSet = null;

        private RwRoDouble() {
        }
    }
}

