/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collectionmaps;

import com.arcway.lib.java.collectionmaps.CollectionMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SetMap<K, V>
implements CollectionMap<K, V> {
    private final HashMap<K, Set<V>> map;

    public SetMap() {
        this.map = new HashMap();
    }

    public SetMap(int capacity) {
        this.map = new HashMap(capacity);
    }

    public SetMap(SetMap<? extends K, ? extends V> setMap) {
        assert (setMap != null);
        HashMap<K, Set<V>> oldMap = setMap.map;
        HashMap newMap = new HashMap(oldMap.size() * 2);
        for (Map.Entry entry : oldMap.entrySet()) {
            newMap.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
        }
        this.map = newMap;
    }

    @Override
    public boolean add(K key, V value) {
        return this.get((Object)key).add(value);
    }

    @Override
    public boolean addAll(K key, Collection<? extends V> c) {
        return this.get((Object)key).addAll(c);
    }

    @Override
    public boolean remove(K key, V value) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        boolean success = this.map.get(key).remove(value);
        if (this.isEmpty(key)) {
            this.map.remove(key);
        }
        return success;
    }

    @Override
    public boolean removeAll(K key, Collection<? extends V> c) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        boolean success = this.map.get(key).removeAll(c);
        if (this.isEmpty(key)) {
            this.map.remove(key);
        }
        return success;
    }

    @Override
    public Set<V> remove(Object key) {
        Set<V> previous = this.map.remove(key);
        return previous;
    }

    @Override
    public Set<V> get(K key) {
        Set<V> set = this.map.get(key);
        if (set == null && !this.map.containsKey(key)) {
            set = new HashSet<V>();
            this.map.put(key, set);
        }
        return set;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty(K key) {
        return this.get((Object)key).isEmpty();
    }

    @Override
    public boolean contains(K key, V value) {
        return this.get((Object)key).contains(value);
    }

    @Override
    public boolean containsAll(K key, Collection<? extends V> values) {
        return this.get((Object)key).containsAll(values);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void addAll(SetMap<? extends K, ? extends V> setMap) {
        for (Map.Entry<K, Set<V>> entry : setMap.map.entrySet()) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }
}

