/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collectionmaps;

import com.arcway.lib.java.tuples.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapMap<A, B, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.5f;
    final HashMap<A, HashMap<B, V>> topLevelMap = new HashMap(16, 0.5f);

    public void clear() {
        this.topLevelMap.clear();
    }

    public boolean containsKey(A keyComponentA, B keyComponentB) {
        HashMap<B, V> secondLevelMap = this.topLevelMap.get(keyComponentA);
        boolean result = secondLevelMap != null ? secondLevelMap.containsKey(keyComponentB) : false;
        return result;
    }

    public V get(A keyComponentA, B keyComponentB) {
        V result = null;
        HashMap<B, V> secondLevelMap = this.topLevelMap.get(keyComponentA);
        if (secondLevelMap != null) {
            result = secondLevelMap.get(keyComponentB);
        }
        return result;
    }

    public Map<B, V> getSecondLevelMapping(A keyComponentA) {
        HashMap<B, V> secondLevelMap = this.topLevelMap.get(keyComponentA);
        if (secondLevelMap != null) {
            return secondLevelMap;
        }
        return Collections.emptyMap();
    }

    public Collection<V> getAllValues(A keyComponentA) {
        HashMap<B, V> secondLevelMap = this.topLevelMap.get(keyComponentA);
        if (secondLevelMap != null) {
            return secondLevelMap.values();
        }
        return Collections.emptySet();
    }

    public Collection<V> getAllValues() {
        if (this.topLevelMap.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<V> values = new ArrayList<V>();
        for (A keyComponentA : this.topLevelMap.keySet()) {
            values.addAll(this.topLevelMap.get(keyComponentA).values());
        }
        return values;
    }

    public Collection<Tuple<A, B>> getKeySet() {
        if (this.topLevelMap.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<Tuple<A, B>> keySet = new ArrayList<Tuple<A, B>>();
        for (Map.Entry<A, HashMap<B, V>> entry : this.topLevelMap.entrySet()) {
            for (B keyComponentB : entry.getValue().keySet()) {
                keySet.add(new Tuple<A, B>(entry.getKey(), keyComponentB));
            }
        }
        return keySet;
    }

    public V put(A keyComponentA, B keyComponentB, V value) {
        HashMap<Object, V> secondLevelMap = this.topLevelMap.get(keyComponentA);
        if (secondLevelMap == null) {
            secondLevelMap = new HashMap(16, 0.5f);
            this.topLevelMap.put(keyComponentA, secondLevelMap);
        }
        return secondLevelMap.put(keyComponentB, value);
    }

    public HashMap<B, V> removeAll(A keyComponentA) {
        return this.topLevelMap.remove(keyComponentA);
    }

    public V remove(A keyComponentA, B keyComponentB) {
        HashMap<B, V> secondLevelMap = this.topLevelMap.get(keyComponentA);
        if (secondLevelMap != null) {
            return secondLevelMap.remove(keyComponentB);
        }
        return null;
    }
}

