/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collectionmaps;

import com.arcway.lib.java.collectionmaps.CollectionMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V>
implements CollectionMap<K, V> {
    private final Map<K, List<V>> map;

    public ListMap() {
        this.map = new HashMap<K, List<V>>();
    }

    public ListMap(int capacity) {
        this.map = new HashMap<K, List<V>>(capacity);
    }

    public ListMap(ListMap<? extends K, ? extends V> listMap) {
        assert (listMap != null);
        Map<K, List<V>> oldMap = super.getMap();
        HashMap newMap = new HashMap(oldMap.size());
        for (Map.Entry<K, List<V>> entry : oldMap.entrySet()) {
            newMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.map = newMap;
    }

    private Map<K, List<V>> getMap() {
        return this.map;
    }

    @Override
    public boolean add(K key, V value) {
        return this.get((Object)key).add(value);
    }

    @Override
    public boolean addAll(K key, Collection<? extends V> c) {
        return this.get((Object)key).addAll(c);
    }

    @Override
    public boolean remove(K key, V value) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        boolean success = this.map.get(key).remove(value);
        if (this.isEmpty(key)) {
            this.map.remove(key);
        }
        return success;
    }

    @Override
    public boolean removeAll(K key, Collection<? extends V> c) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        boolean success = this.map.get(key).removeAll(c);
        if (this.isEmpty(key)) {
            this.map.remove(key);
        }
        return success;
    }

    @Override
    public List<V> remove(Object key) {
        List<V> previous = this.map.remove(key);
        return previous;
    }

    @Override
    public List<V> get(K key) {
        List<V> list = this.map.get(key);
        if (list == null && !this.map.containsKey(key)) {
            list = new ArrayList<V>();
            this.map.put(key, list);
        }
        return list;
    }

    private List<V> getReadOnly(Object key) {
        List<V> list = this.map.get(key);
        if (list == null && !this.map.containsKey(key)) {
            list = new ArrayList<V>();
        }
        return list;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty(K key) {
        return this.get((Object)key).isEmpty();
    }

    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public boolean contains(K key, V value) {
        return this.get((Object)key).contains(value);
    }

    @Override
    public boolean containsAll(K key, Collection<? extends V> values) {
        return this.get((Object)key).containsAll(values);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void addAll(ListMap<? extends K, ? extends V> listMap) {
        for (Map.Entry<K, List<V>> entry : super.getMap().entrySet()) {
            this.addAll(entry.getKey(), super.getReadOnly(entry.getKey()));
        }
    }
}

